/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.index.VersionType;
import io.skylite.core.mapper.LuceneDocument;
import io.skylite.core.mapper.ParsedDocument;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.Term;

public abstract class EngineOperation {
    private final Term uid;
    private final long version;
    private final long seqNo;
    private final long primaryTerm;
    private final VersionType versionType;
    private final Origin origin;
    private final long startTime;

    public EngineOperation(Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Origin origin, long startTime) {
        this.uid = uid;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.version = version;
        this.versionType = versionType;
        this.origin = origin;
        this.startTime = startTime;
    }

    public Origin origin() {
        return this.origin;
    }

    public Term uid() {
        return this.uid;
    }

    public long version() {
        return this.version;
    }

    public long seqNo() {
        return this.seqNo;
    }

    public long primaryTerm() {
        return this.primaryTerm;
    }

    public abstract int estimatedSizeInBytes();

    public VersionType versionType() {
        return this.versionType;
    }

    public long startTime() {
        return this.startTime;
    }

    public abstract String id();

    public abstract TYPE operationType();

    public static enum Origin {
        PRIMARY,
        REPLICA,
        PEER_RECOVERY,
        LOCAL_TRANSLOG_RECOVERY,
        LOCAL_RESET;


        public boolean isRecovery() {
            return this == PEER_RECOVERY || this == LOCAL_TRANSLOG_RECOVERY;
        }

        public boolean isFromTranslog() {
            return this == LOCAL_TRANSLOG_RECOVERY || this == LOCAL_RESET;
        }
    }

    public static class NoOp
    extends EngineOperation {
        private final String reason;

        public String reason() {
            return this.reason;
        }

        public NoOp(long seqNo, long primaryTerm, Origin origin, long startTime, String reason) {
            super(null, seqNo, primaryTerm, -1L, null, origin, startTime);
            this.reason = reason;
        }

        @Override
        public Term uid() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long version() {
            throw new UnsupportedOperationException();
        }

        @Override
        public VersionType versionType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String id() {
            throw new UnsupportedOperationException();
        }

        @Override
        public TYPE operationType() {
            return TYPE.NO_OP;
        }

        @Override
        public int estimatedSizeInBytes() {
            return 2 * this.reason.length() + 16;
        }
    }

    public static class Delete
    extends EngineOperation {
        private final String id;
        private final long ifSeqNo;
        private final long ifPrimaryTerm;

        public Delete(String id, Term uid, long seqNo, long primaryTerm, long version, VersionType versionType, Origin origin, long startTime, long ifSeqNo, long ifPrimaryTerm) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            assert (origin == Origin.PRIMARY == (versionType != null)) : "invalid version_type=" + String.valueOf(versionType) + " for origin=" + String.valueOf((Object)origin);
            assert (ifPrimaryTerm >= 0L) : "ifPrimaryTerm [" + ifPrimaryTerm + "] must be non negative";
            assert (ifSeqNo == -2L || ifSeqNo >= 0L) : "ifSeqNo [" + ifSeqNo + "] must be non negative or unset";
            assert (origin == Origin.PRIMARY || ifSeqNo == -2L && ifPrimaryTerm == 0L) : "cas operations are only allowed if origin is primary. get [" + String.valueOf((Object)origin) + "]";
            this.id = Objects.requireNonNull(id);
            this.ifSeqNo = ifSeqNo;
            this.ifPrimaryTerm = ifPrimaryTerm;
        }

        public Delete(String id, Term uid, long primaryTerm) {
            this(id, uid, -2L, primaryTerm, -3L, VersionType.INTERNAL, Origin.PRIMARY, System.nanoTime(), -2L, 0L);
        }

        public Delete(Delete template, VersionType versionType) {
            this(template.id(), template.uid(), template.seqNo(), template.primaryTerm(), template.version(), versionType, template.origin(), template.startTime(), -2L, 0L);
        }

        @Override
        public String id() {
            return this.id;
        }

        @Override
        public TYPE operationType() {
            return TYPE.DELETE;
        }

        @Override
        public int estimatedSizeInBytes() {
            return (this.uid().field().length() + this.uid().text().length()) * 2 + 20;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static class Index
    extends EngineOperation {
        private final ParsedDocument doc;
        private final long autoGeneratedIdTimestamp;
        private final boolean isRetry;
        private final long ifSeqNo;
        private final long ifPrimaryTerm;

        public Index(Term uid, ParsedDocument doc, long seqNo, long primaryTerm, long version, VersionType versionType, Origin origin, long startTime, long autoGeneratedIdTimestamp, boolean isRetry, long ifSeqNo, long ifPrimaryTerm) {
            super(uid, seqNo, primaryTerm, version, versionType, origin, startTime);
            assert (origin == Origin.PRIMARY == (versionType != null)) : "invalid version_type=" + String.valueOf(versionType) + " for origin=" + String.valueOf((Object)origin);
            assert (ifPrimaryTerm >= 0L) : "ifPrimaryTerm [" + ifPrimaryTerm + "] must be non negative";
            assert (ifSeqNo == -2L || ifSeqNo >= 0L) : "ifSeqNo [" + ifSeqNo + "] must be non negative or unset";
            assert (origin == Origin.PRIMARY || ifSeqNo == -2L && ifPrimaryTerm == 0L) : "cas operations are only allowed if origin is primary. get [" + String.valueOf((Object)origin) + "]";
            this.doc = doc;
            this.isRetry = isRetry;
            this.autoGeneratedIdTimestamp = autoGeneratedIdTimestamp;
            this.ifSeqNo = ifSeqNo;
            this.ifPrimaryTerm = ifPrimaryTerm;
        }

        public Index(Term uid, long primaryTerm, ParsedDocument doc) {
            this(uid, primaryTerm, doc, -3L);
        }

        public Index(Term uid, long primaryTerm, ParsedDocument doc, long version) {
            this(uid, doc, -2L, primaryTerm, version, VersionType.INTERNAL, Origin.PRIMARY, System.nanoTime(), -1L, false, -2L, 0L);
        }

        public ParsedDocument parsedDoc() {
            return this.doc;
        }

        @Override
        public String id() {
            return this.doc.id();
        }

        @Override
        public TYPE operationType() {
            return TYPE.INDEX;
        }

        public String routing() {
            return this.doc.routing();
        }

        public List<LuceneDocument> docs() {
            return this.doc.docs();
        }

        public BytesReference source() {
            return this.doc.source();
        }

        @Override
        public int estimatedSizeInBytes() {
            return this.id().length() * 2 + this.source().length() + 12;
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }

        public boolean isRetry() {
            return this.isRetry;
        }

        public long getIfSeqNo() {
            return this.ifSeqNo;
        }

        public long getIfPrimaryTerm() {
            return this.ifPrimaryTerm;
        }
    }

    public static enum TYPE {
        INDEX,
        DELETE,
        NO_OP;

        private final String lowercase = this.toString().toLowerCase(Locale.ROOT);

        public String getLowercase() {
            return this.lowercase;
        }
    }
}

