/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.common.concurrent.GatedCloseable;
import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.common.unit.TimeValue;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.engine.CompletionStatsCache;
import io.skylite.core.index.engine.Engine;
import io.skylite.core.index.engine.EngineConfig;
import io.skylite.core.index.engine.EngineCreationFailureException;
import io.skylite.core.index.engine.EngineException;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.engine.FlushFailedEngineException;
import io.skylite.core.index.engine.NRTReplicationReaderManager;
import io.skylite.core.index.engine.ReplicaFileTracker;
import io.skylite.core.index.engine.SafeCommitInfo;
import io.skylite.core.index.engine.Segment;
import io.skylite.core.index.seqno.LocalCheckpointTracker;
import io.skylite.core.index.seqno.SeqNoStats;
import io.skylite.core.index.seqno.SequenceNumbers;
import io.skylite.core.index.translog.TranslogCorruptedException;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogException;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogManager;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.WriteOnlyTranslogManager;
import io.skylite.core.index.translog.listener.TranslogEventListener;
import io.skylite.core.lucene.XLucene;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.mapper.DocumentParser;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.search.suggest.completion.CompletionStats;
import java.io.Closeable;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.store.Directory;

public class NRTReplicationEngine
extends Engine {
    private volatile SegmentInfos lastCommittedSegmentInfos;
    private final NRTReplicationReaderManager readerManager;
    private final CompletionStatsCache completionStatsCache;
    private final LocalCheckpointTracker localCheckpointTracker;
    private final WriteOnlyTranslogManager translogManager;
    private final Lock flushLock = new ReentrantLock();
    protected final ReplicaFileTracker replicaFileTracker;
    private volatile long lastReceivedPrimaryGen = -1L;
    private static final int SI_COUNTER_INCREMENT = 10;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public NRTReplicationEngine(EngineConfig engineConfig) {
        super(engineConfig);
        this.store.incRef();
        NRTReplicationReaderManager readerManager = null;
        WriteOnlyTranslogManager translogManagerRef = null;
        boolean success = false;
        try {
            this.replicaFileTracker = new ReplicaFileTracker((xva$0, xva$1) -> this.store.deleteQuiet((String)xva$0, (String)xva$1));
            this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
            this.replicaFileTracker.incRef(this.lastCommittedSegmentInfos.files(true));
            this.cleanUnreferencedFiles();
            readerManager = this.buildReaderManager();
            SequenceNumbers.CommitInfo commitInfo = SequenceNumbers.loadSeqNoInfoFromLuceneCommit(this.lastCommittedSegmentInfos.getUserData().entrySet());
            this.localCheckpointTracker = new LocalCheckpointTracker(commitInfo.maxSeqNo, commitInfo.localCheckpoint);
            this.completionStatsCache = new CompletionStatsCache(() -> this.acquireSearcher("completion_stats"));
            this.readerManager = readerManager;
            this.readerManager.addListener(this.completionStatsCache);
            for (ReferenceManager.RefreshListener listener : engineConfig.getInternalRefreshListener()) {
                this.readerManager.addListener(listener);
            }
            Map userData = this.lastCommittedSegmentInfos.getUserData();
            String translogUUID = Objects.requireNonNull((String)userData.get("translog_uuid"));
            this.translogManager = translogManagerRef = new WriteOnlyTranslogManager(engineConfig.getTranslogConfig(), engineConfig.getPrimaryTermSupplier(), engineConfig.getGlobalCheckpointSupplier(), this.getTranslogDeletionPolicy(engineConfig), this.shardId, this.readLock, this::getLocalCheckpointTracker, translogUUID, new TranslogEventListener(){

                @Override
                public void onFailure(String reason, Exception ex) {
                    NRTReplicationEngine.this.failEngine(reason, ex);
                }

                @Override
                public void onAfterTranslogSync() {
                    try {
                        NRTReplicationEngine.this.translogManager.trimUnreferencedReaders();
                    }
                    catch (IOException ex) {
                        throw new TranslogException(NRTReplicationEngine.this.shardId, "failed to trim unreferenced translog readers", ex);
                    }
                }
            }, this, engineConfig.getTranslogFactory(), engineConfig.getStartedPrimarySupplier());
            success = true;
            if (success) return;
        }
        catch (TranslogCorruptedException | IOException e) {
            try {
                throw new EngineCreationFailureException(this.shardId, "failed to create engine", e);
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{readerManager, translogManagerRef});
                if (this.isClosed.get()) throw throwable;
                this.store.decRef();
                throw throwable;
            }
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{readerManager, translogManagerRef});
        if (this.isClosed.get()) return;
        this.store.decRef();
        return;
    }

    public void cleanUnreferencedFiles() throws IOException {
        this.replicaFileTracker.deleteUnreferencedFiles(this.store.directory().listAll());
    }

    private NRTReplicationReaderManager buildReaderManager() throws IOException {
        return new NRTReplicationReaderManager(SkyliteDirectoryReader.wrap(this.getDirectoryReader(), this.shardId), this.replicaFileTracker::incRef, this.replicaFileTracker::decRef);
    }

    @Override
    public TranslogManager translogManager() {
        return this.translogManager;
    }

    public synchronized void updateSegments(SegmentInfos infos) throws IOException {
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            long maxSeqNo = Long.parseLong((String)infos.userData.get("max_seq_no"));
            long incomingGeneration = infos.getGeneration();
            this.readerManager.updateSegments(infos);
            if (incomingGeneration != this.lastReceivedPrimaryGen) {
                this.flush(false, true);
                this.translogManager.getDeletionPolicy().setLocalCheckpointOfSafeCommit(maxSeqNo);
                this.translogManager.rollTranslogGeneration();
            }
            this.lastReceivedPrimaryGen = incomingGeneration;
            this.localCheckpointTracker.fastForwardProcessedSeqNo(maxSeqNo);
        }
    }

    private void commitSegmentInfos(SegmentInfos infos) throws IOException {
        Collection previousCommitFiles = this.getLastCommittedSegmentInfos().files(true);
        this.store.commitSegmentInfos(infos, this.localCheckpointTracker.getMaxSeqNo(), this.localCheckpointTracker.getProcessedCheckpoint());
        this.lastCommittedSegmentInfos = this.store.readLastCommittedSegmentsInfo();
        this.replicaFileTracker.incRef(this.lastCommittedSegmentInfos.files(true));
        this.replicaFileTracker.decRef(previousCommitFiles);
        this.translogManager.syncTranslog();
    }

    private void commitSegmentInfos() throws IOException {
        this.commitSegmentInfos(this.getLatestSegmentInfos());
    }

    @Override
    public String getHistoryUUID() {
        return this.loadHistoryUUID(this.lastCommittedSegmentInfos.userData);
    }

    @Override
    public long getWritingBytes() {
        return 0L;
    }

    @Override
    public CompletionStats completionStats(String ... fieldNamePatterns) {
        return this.completionStatsCache.get(fieldNamePatterns);
    }

    @Override
    public long getIndexThrottleTimeInMillis() {
        return 0L;
    }

    @Override
    public boolean isThrottled() {
        return false;
    }

    @Override
    public EngineResult.IndexResult index(EngineOperation.Index index) throws IOException {
        this.ensureOpen();
        EngineResult.IndexResult indexResult = new EngineResult.IndexResult(index.version(), index.primaryTerm(), index.seqNo(), false);
        TranslogLocation location = this.translogManager.add(new TranslogOperation.Index(index, indexResult));
        indexResult.setTranslogLocation(location);
        indexResult.setTook(System.nanoTime() - index.startTime());
        indexResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(index.seqNo());
        return indexResult;
    }

    @Override
    public EngineResult.DeleteResult delete(EngineOperation.Delete delete) throws IOException {
        this.ensureOpen();
        EngineResult.DeleteResult deleteResult = new EngineResult.DeleteResult(delete.version(), delete.primaryTerm(), delete.seqNo(), true);
        TranslogLocation location = this.translogManager.add(new TranslogOperation.Delete(delete, deleteResult));
        deleteResult.setTranslogLocation(location);
        deleteResult.setTook(System.nanoTime() - delete.startTime());
        deleteResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(delete.seqNo());
        return deleteResult;
    }

    @Override
    public EngineResult.NoOpResult noOp(EngineOperation.NoOp noOp) throws IOException {
        this.ensureOpen();
        EngineResult.NoOpResult noOpResult = new EngineResult.NoOpResult(noOp.primaryTerm(), noOp.seqNo());
        TranslogLocation location = this.translogManager.add(new TranslogOperation.NoOp(noOp.seqNo(), noOp.primaryTerm(), noOp.reason()));
        noOpResult.setTranslogLocation(location);
        noOpResult.setTook(System.nanoTime() - noOp.startTime());
        noOpResult.freeze();
        this.localCheckpointTracker.advanceMaxSeqNo(noOp.seqNo());
        return noOpResult;
    }

    @Override
    public Engine.GetResult get(Engine.Get get, MappingLookup mappingLookup, DocumentParser documentParser, Function<Engine.Searcher, Engine.Searcher> searcherWrapper) throws EngineException {
        return this.getFromSearcher(get, this.acquireSearcher("get", Engine.SearcherScope.EXTERNAL, searcherWrapper), false);
    }

    @Override
    protected ReferenceManager<SkyliteDirectoryReader> getReferenceManager(Engine.SearcherScope scope) {
        return this.readerManager;
    }

    @Override
    public boolean refreshNeeded() {
        return false;
    }

    @Override
    public Closeable acquireHistoryRetentionLock() {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public TranslogSnapshotIterator newChangesSnapshot(String source, long fromSeqNo, long toSeqNo, boolean requiredFullRange, boolean accurateCount) throws IOException {
        throw new UnsupportedOperationException("Not implemented");
    }

    @Override
    public int countNumberOfHistoryOperations(String source, long fromSeqNo, long toSeqNumber) throws IOException {
        return 0;
    }

    @Override
    public boolean hasCompleteOperationHistory(String reason, long startingSeqNo) {
        return false;
    }

    @Override
    public long getMinRetainedSeqNo() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public long getPersistedLocalCheckpoint() {
        return this.localCheckpointTracker.getPersistedCheckpoint();
    }

    @Override
    public long getProcessedLocalCheckpoint() {
        return this.localCheckpointTracker.getProcessedCheckpoint();
    }

    @Override
    public SeqNoStats getSeqNoStats(long globalCheckpoint) {
        return this.localCheckpointTracker.getStats(globalCheckpoint);
    }

    @Override
    public long getLastSyncedGlobalCheckpoint() {
        return this.translogManager.getLastSyncedGlobalCheckpoint();
    }

    @Override
    public long getIndexBufferRAMBytesUsed() {
        return 0L;
    }

    @Override
    public List<Segment> segments(boolean verbose) {
        return Arrays.asList(this.getSegmentInfo(this.getLatestSegmentInfos(), verbose));
    }

    @Override
    public void refresh(String source) throws EngineException {
    }

    @Override
    public boolean maybeRefresh(String source) throws EngineException {
        return false;
    }

    @Override
    public void writeIndexingBuffer() throws EngineException {
    }

    @Override
    public boolean shouldPeriodicallyFlush() {
        return false;
    }

    @Override
    public void flush(boolean force, boolean waitIfOngoing) throws EngineException {
        this.ensureOpen();
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            if (!this.flushLock.tryLock()) {
                if (!waitIfOngoing) {
                    return;
                }
                this.flushLock.lock();
            }
            try {
                this.commitSegmentInfos();
            }
            catch (IOException e) {
                this.maybeFailEngine("flush", e);
                throw new FlushFailedEngineException(this.shardId, (Throwable)e);
            }
            finally {
                this.flushLock.unlock();
            }
        }
    }

    @Override
    public void forceMerge(boolean flush, int maxNumSegments, boolean onlyExpungeDeletes, boolean upgrade, boolean upgradeOnlyAncientSegments, String forceMergeUUID) throws EngineException, IOException {
    }

    @Override
    public GatedCloseable<IndexCommit> acquireLastIndexCommit(boolean flushFirst) throws EngineException {
        if (flushFirst) {
            this.flush(false, true);
        }
        try {
            IndexCommit indexCommit = XLucene.getIndexCommit(this.lastCommittedSegmentInfos, this.store.directory());
            return new GatedCloseable((Object)indexCommit, () -> {});
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, "Unable to build latest IndexCommit", e, new Object[0]);
        }
    }

    @Override
    public GatedCloseable<IndexCommit> acquireSafeIndexCommit() throws EngineException {
        return this.acquireLastIndexCommit(false);
    }

    @Override
    public SafeCommitInfo getSafeCommitInfo() {
        return new SafeCommitInfo(this.localCheckpointTracker.getProcessedCheckpoint(), this.lastCommittedSegmentInfos.totalMaxDoc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void closeNoLock(String reason, CountDownLatch closedLatch) {
        if (this.isClosed.compareAndSet(false, true)) {
            assert (this.rwl.isWriteLockedByCurrentThread() || this.failEngineLock.isHeldByCurrentThread()) : "Either the write lock must be held or the engine must be currently be failing itself";
            try {
                block19: {
                    SegmentInfos latestSegmentInfos = this.getLatestSegmentInfos();
                    if (!this.engineConfig.getIndexSettings().isRemoteStoreEnabled() && !this.engineConfig.getIndexSettings().isAssignedOnRemoteNode()) {
                        latestSegmentInfos.counter += 10L;
                        latestSegmentInfos.changed();
                    }
                    try {
                        this.commitSegmentInfos(latestSegmentInfos);
                    }
                    catch (IOException e) {
                        if (this.failEngineLock.isHeldByCurrentThread() || this.store.isMarkedCorrupted()) break block19;
                        try {
                            this.store.markStoreCorrupted(e);
                        }
                        catch (IOException ex) {
                            this.logger.warn("Unable to mark store corrupted", (Throwable)ex);
                        }
                    }
                }
                IOUtils.close((Closeable[])new Closeable[]{this.readerManager, this.translogManager});
            }
            catch (Exception e) {
                this.logger.error("failed to close engine", (Throwable)e);
            }
            finally {
                try {
                    this.store.decRef();
                    this.logger.debug("engine closed [{}]", (Object)reason);
                }
                finally {
                    closedLatch.countDown();
                }
            }
        }
    }

    @Override
    public void activateThrottling() {
    }

    @Override
    public void deactivateThrottling() {
    }

    @Override
    public int fillSeqNoGaps(long primaryTerm) throws IOException {
        return 0;
    }

    @Override
    public void maybePruneDeletes() {
    }

    @Override
    public void updateMaxUnsafeAutoIdTimestamp(long newTimestamp) {
    }

    @Override
    public long getMaxSeqNoOfUpdatesOrDeletes() {
        return this.localCheckpointTracker.getMaxSeqNo();
    }

    @Override
    public void advanceMaxSeqNoOfUpdatesOrDeletes(long maxSeqNoOfUpdatesOnPrimary) {
    }

    @Override
    public void onSettingsChanged(TimeValue translogRetentionAge, ByteSizeValue translogRetentionSize, long softDeletesRetentionOps) {
        TranslogDeletionPolicy translogDeletionPolicy = this.translogManager.getDeletionPolicy();
        translogDeletionPolicy.setRetentionAgeInMillis(translogRetentionAge.millis());
        translogDeletionPolicy.setRetentionSizeInBytes(translogRetentionSize.getBytes());
    }

    @Override
    protected SegmentInfos getLastCommittedSegmentInfos() {
        return this.lastCommittedSegmentInfos;
    }

    @Override
    protected SegmentInfos getLatestSegmentInfos() {
        return this.readerManager.getSegmentInfos();
    }

    @Override
    public synchronized GatedCloseable<SegmentInfos> getSegmentInfosSnapshot() {
        SegmentInfos latestSegmentInfos = this.getLatestSegmentInfos();
        try {
            Collection files = latestSegmentInfos.files(false);
            this.replicaFileTracker.incRef(files);
            return new GatedCloseable((Object)latestSegmentInfos, () -> this.replicaFileTracker.decRef(files));
        }
        catch (IOException e) {
            throw new EngineException(this.shardId, e.getMessage(), e, new Object[0]);
        }
    }

    protected LocalCheckpointTracker getLocalCheckpointTracker() {
        return this.localCheckpointTracker;
    }

    private DirectoryReader getDirectoryReader() throws IOException {
        return new SoftDeletesDirectoryReaderWrapper(DirectoryReader.open((Directory)this.store.directory()), "__soft_deletes");
    }
}

