/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.engine;

import io.skylite.core.index.engine.LuceniaReaderManager;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SoftDeletesDirectoryReaderWrapper;
import org.apache.lucene.index.StandardDirectoryReader;
import org.apache.lucene.store.Directory;

public class NRTReplicationReaderManager
extends LuceniaReaderManager {
    private static final Logger logger = LogManager.getLogger(NRTReplicationReaderManager.class);
    private volatile SegmentInfos currentInfos;
    private Consumer<Collection<String>> onReaderClosed;
    private Consumer<Collection<String>> onNewReader;

    NRTReplicationReaderManager(SkyliteDirectoryReader reader, Consumer<Collection<String>> onNewReader, Consumer<Collection<String>> onReaderClosed) {
        super(reader);
        this.currentInfos = NRTReplicationReaderManager.unwrapStandardReader(reader).getSegmentInfos();
        this.onNewReader = onNewReader;
        this.onReaderClosed = onReaderClosed;
    }

    @Override
    protected SkyliteDirectoryReader refreshIfNeeded(SkyliteDirectoryReader referenceToRefresh) throws IOException {
        Objects.requireNonNull(referenceToRefresh);
        if (NRTReplicationReaderManager.unwrapStandardReader((SkyliteDirectoryReader)referenceToRefresh).getSegmentInfos().version == this.currentInfos.version) {
            return null;
        }
        ArrayList<LeafReader> subs = new ArrayList<LeafReader>();
        StandardDirectoryReader standardDirectoryReader = NRTReplicationReaderManager.unwrapStandardReader(referenceToRefresh);
        for (LeafReaderContext ctx : standardDirectoryReader.leaves()) {
            subs.add(ctx.reader());
        }
        Collection files = this.currentInfos.files(false);
        DirectoryReader innerReader = StandardDirectoryReader.open((Directory)referenceToRefresh.directory(), (SegmentInfos)this.currentInfos, subs, null);
        SoftDeletesDirectoryReaderWrapper softDeletesDirectoryReaderWrapper = new SoftDeletesDirectoryReaderWrapper(innerReader, "__soft_deletes");
        logger.trace(() -> new ParameterizedMessage("updated to SegmentInfosVersion=" + this.currentInfos.getVersion() + " reader=" + String.valueOf(innerReader), new Object[0]));
        SkyliteDirectoryReader reader = SkyliteDirectoryReader.wrap((DirectoryReader)softDeletesDirectoryReaderWrapper, referenceToRefresh.shardId());
        this.onNewReader.accept(files);
        SkyliteDirectoryReader.addReaderCloseListener((DirectoryReader)reader, key -> this.onReaderClosed.accept(files));
        return reader;
    }

    public void updateSegments(SegmentInfos infos) throws IOException {
        infos.updateGeneration(this.currentInfos);
        this.currentInfos = infos;
        this.maybeRefresh();
    }

    public SegmentInfos getSegmentInfos() {
        return this.currentInfos;
    }

    public static StandardDirectoryReader unwrapStandardReader(SkyliteDirectoryReader reader) {
        DirectoryReader delegate = reader.getDelegate();
        if (delegate instanceof SoftDeletesDirectoryReaderWrapper) {
            return (StandardDirectoryReader)((SoftDeletesDirectoryReaderWrapper)delegate).getDelegate();
        }
        return (StandardDirectoryReader)delegate;
    }
}

