/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.time.DateFormatter;
import io.skylite.core.common.time.DateMathParser;
import io.skylite.core.common.time.DateResolution;
import io.skylite.core.index.fielddata.DocValueFormat;
import java.io.IOException;
import java.time.ZoneId;
import java.util.Objects;
import java.util.function.LongSupplier;

public final class DocValueDateFormatters {
    private DocValueDateFormatters() {
    }

    public static DocValueFormat withNanosecondResolution(DocValueFormat format) {
        if (format instanceof DateTime) {
            DateTime dateTime = (DateTime)format;
            return new DateTime(dateTime.formatter, dateTime.timeZone, DateResolution.NANOSECONDS);
        }
        throw new IllegalArgumentException("trying to convert a known date time formatter to a nanosecond one, wrong field used?");
    }

    public static final class DateTime
    implements DocValueFormat {
        public static final String NAME = "date_time";
        final DateFormatter formatter;
        final ZoneId timeZone;
        private final DateMathParser parser;
        final DateResolution resolution;

        public DateTime(DateFormatter formatter, ZoneId timeZone, DateResolution resolution) {
            this.formatter = formatter;
            this.timeZone = Objects.requireNonNull(timeZone);
            this.parser = formatter.toDateMathParser();
            this.resolution = resolution;
        }

        public DateTime(StreamInput in) throws IOException {
            Version inVersion = in.getVersion();
            this.formatter = inVersion.onOrAfter(OpenSearchVersion.V_2_12_0) ? DateFormatter.forPattern(in.readString(), in.readOptionalString()) : DateFormatter.forPattern(in.readString(), inVersion);
            this.parser = this.formatter.toDateMathParser();
            String zoneId = in.readString();
            this.timeZone = ZoneId.of(zoneId);
            this.resolution = DateResolution.ofOrdinal(in.readVInt());
            if (in.getVersion().before(OpenSearchVersion.V_3_0_0)) {
                in.readBoolean();
            }
        }

        @Override
        public String getWriteableName() {
            return NAME;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            if (out.getVersion().before(OpenSearchVersion.V_2_12_0) && this.formatter.equals(DateFormatter.DEFAULT_DATE_TIME_FORMATTER)) {
                out.writeString(DateFormatter.LEGACY_DEFAULT_DATE_TIME_FORMATTER.pattern());
            } else {
                out.writeString(this.formatter.pattern());
            }
            if (out.getVersion().onOrAfter(OpenSearchVersion.V_2_12_0)) {
                out.writeOptionalString(this.formatter.printPattern());
            }
            out.writeString(this.timeZone.getId());
            out.writeVInt(this.resolution.ordinal());
            if (out.getVersion().before(OpenSearchVersion.V_3_0_0)) {
                out.writeBoolean(false);
            }
        }

        public DateMathParser getDateMathParser() {
            return this.parser;
        }

        @Override
        public String format(long value) {
            return this.formatter.format(this.resolution.toInstant(value).atZone(this.timeZone));
        }

        @Override
        public String format(double value) {
            return this.format((long)value);
        }

        @Override
        public long parseLong(String value, boolean roundUp, LongSupplier now) {
            return this.resolution.convert(this.parser.parse(value, now, roundUp, this.timeZone));
        }

        @Override
        public double parseDouble(String value, boolean roundUp, LongSupplier now) {
            return this.parseLong(value, roundUp, now);
        }

        public String toString() {
            return "DocValueFormat.DateTime(" + String.valueOf(this.formatter) + ", " + String.valueOf(this.timeZone) + ", " + String.valueOf((Object)this.resolution) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DateTime that = (DateTime)o;
            return Objects.equals(this.formatter, that.formatter) && Objects.equals(this.timeZone, that.timeZone) && Objects.equals((Object)this.resolution, (Object)that.resolution);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.formatter, this.timeZone, this.resolution});
        }
    }
}

