/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.NestedSortBuilder;
import io.skylite.core.search.sort.SortOrder;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.BytesRef;

public abstract class IndexFieldDataFieldComparatorSource
extends FieldComparatorSource {
    protected final MultiValueMode sortMode;
    protected final Object missingValue;
    protected final Nested nested;
    protected boolean enableSkipping;

    public IndexFieldDataFieldComparatorSource(Object missingValue, MultiValueMode sortMode, Nested nested) {
        this.sortMode = sortMode;
        this.missingValue = missingValue;
        this.nested = nested;
        this.enableSkipping = true;
    }

    public MultiValueMode sortMode() {
        return this.sortMode;
    }

    public Nested nested() {
        return this.nested;
    }

    public void disableSkipping() {
        this.enableSkipping = false;
    }

    public Pruning filterPruning(Pruning pruning) {
        return this.enableSkipping ? pruning : Pruning.NONE;
    }

    public final boolean sortMissingFirst(Object missingValue) {
        return "_first".equals(missingValue);
    }

    public final boolean sortMissingLast(Object missingValue) {
        return missingValue == null || "_last".equals(missingValue);
    }

    public Object missingObject(Object missingValue, boolean reversed) {
        if (this.sortMissingFirst(missingValue) || this.sortMissingLast(missingValue)) {
            boolean min = this.sortMissingFirst(missingValue) ^ reversed;
            switch (this.reducedType()) {
                case INT: {
                    return min ? Integer.MIN_VALUE : Integer.MAX_VALUE;
                }
                case LONG: {
                    return min ? Long.MIN_VALUE : Long.MAX_VALUE;
                }
                case FLOAT: {
                    return Float.valueOf(min ? Float.NEGATIVE_INFINITY : Float.POSITIVE_INFINITY);
                }
                case DOUBLE: {
                    return min ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
                }
                case STRING: 
                case STRING_VAL: {
                    return null;
                }
            }
            throw new UnsupportedOperationException("Unsupported reduced type: " + String.valueOf(this.reducedType()));
        }
        switch (this.reducedType()) {
            case INT: {
                if (missingValue instanceof Number) {
                    return ((Number)missingValue).intValue();
                }
                return Integer.parseInt(missingValue.toString());
            }
            case LONG: {
                if (missingValue instanceof Number) {
                    return ((Number)missingValue).longValue();
                }
                return Long.parseLong(missingValue.toString());
            }
            case FLOAT: {
                if (missingValue instanceof Number) {
                    return Float.valueOf(((Number)missingValue).floatValue());
                }
                return Float.valueOf(Float.parseFloat(missingValue.toString()));
            }
            case DOUBLE: {
                if (missingValue instanceof Number) {
                    return ((Number)missingValue).doubleValue();
                }
                return Double.parseDouble(missingValue.toString());
            }
            case STRING: 
            case STRING_VAL: {
                if (missingValue instanceof BytesRef) {
                    return (BytesRef)missingValue;
                }
                if (missingValue instanceof byte[]) {
                    return new BytesRef((byte[])missingValue);
                }
                return new BytesRef((CharSequence)missingValue.toString());
            }
        }
        throw new UnsupportedOperationException("Unsupported reduced type: " + String.valueOf(this.reducedType()));
    }

    public abstract SortField.Type reducedType();

    public Object missingValue(boolean reversed) {
        return null;
    }

    public abstract BucketedSort newBucketedSort(BigArrays var1, SortOrder var2, DocValueFormat var3, int var4, BucketedSort.ExtraData var5);

    public static class Nested {
        private final BitSetProducer rootFilter;
        private final Query innerQuery;
        private final NestedSortBuilder nestedSort;
        private final IndexSearcher searcher;

        public Nested(BitSetProducer rootFilter, Query innerQuery, NestedSortBuilder nestedSort, IndexSearcher searcher) {
            this.rootFilter = rootFilter;
            this.innerQuery = innerQuery;
            this.nestedSort = nestedSort;
            this.searcher = searcher;
        }

        public Query getInnerQuery() {
            return this.innerQuery;
        }

        public NestedSortBuilder getNestedSort() {
            return this.nestedSort;
        }

        public BitSet rootDocs(LeafReaderContext ctx) throws IOException {
            return this.rootFilter.getBitSet(ctx);
        }

        public DocIdSetIterator innerDocs(LeafReaderContext ctx) throws IOException {
            Weight weight = this.searcher.createWeight(this.searcher.rewrite(this.innerQuery), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
            Scorer s = weight.scorer(ctx);
            return s == null ? null : s.iterator();
        }
    }
}

