/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.core.index.AbstractIndexComponent;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.IndexSortConfig;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.indices.fielddata.cache.IndicesFieldDataCache;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.search.sort.SortOrder;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;

public class IndexFieldDataService
extends AbstractIndexComponent
implements Closeable {
    public static final String FIELDDATA_CACHE_VALUE_NODE = "node";
    public static final String FIELDDATA_CACHE_KEY = "index.fielddata.cache";
    public static final Setting<String> INDEX_FIELDDATA_CACHE_KEY = new Setting<String>("index.fielddata.cache", s -> "node", s -> {
        switch (s) {
            case "node": 
            case "none": {
                return s;
            }
        }
        throw new IllegalArgumentException("failed to parse [" + s + "] must be one of [node,none]");
    }, Setting.Property.IndexScope);
    private final CircuitBreakerService circuitBreakerService;
    private final IndicesFieldDataCache indicesFieldDataCache;
    private final Map<String, IndexFieldDataCache> fieldDataCaches = new HashMap<String, IndexFieldDataCache>();
    private final MapperService mapperService;
    private static final IndexFieldDataCache.Listener DEFAULT_NOOP_LISTENER = new IndexFieldDataCache.Listener(){

        @Override
        public void onCache(ShardId shardId, String fieldName, Accountable ramUsage) {
        }

        @Override
        public void onRemoval(ShardId shardId, String fieldName, boolean wasEvicted, long sizeInBytes) {
        }
    };
    private volatile IndexFieldDataCache.Listener listener = DEFAULT_NOOP_LISTENER;

    public IndexFieldDataService(IndexSettings indexSettings, IndicesFieldDataCache indicesFieldDataCache, CircuitBreakerService circuitBreakerService, MapperService mapperService) {
        super(indexSettings);
        this.indicesFieldDataCache = indicesFieldDataCache;
        this.circuitBreakerService = circuitBreakerService;
        this.mapperService = mapperService;
    }

    public synchronized void clear() {
        ArrayList<Exception> exceptions = new ArrayList<Exception>(0);
        Collection<IndexFieldDataCache> fieldDataCacheValues = this.fieldDataCaches.values();
        for (IndexFieldDataCache cache : fieldDataCacheValues) {
            try {
                cache.clear();
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        fieldDataCacheValues.clear();
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    public synchronized void clearField(String fieldName) {
        ArrayList<Exception> exceptions = new ArrayList<Exception>(0);
        IndexFieldDataCache cache = this.fieldDataCaches.remove(fieldName);
        if (cache != null) {
            try {
                cache.clear(fieldName);
            }
            catch (Exception e) {
                exceptions.add(e);
            }
        }
        SkyliteExceptionsHelper.maybeThrowRuntimeAndSuppress(exceptions);
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(BaseMappedFieldType fieldType, String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        return this.getForField((MappedFieldType)MappedFieldType.class.cast(fieldType), fullyQualifiedIndexName, searchLookup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType, String fullyQualifiedIndexName, Supplier<SearchLookup> searchLookup) {
        IndexFieldDataCache cache;
        String fieldName = fieldType.name();
        BaseIndexFieldData.Builder builder = fieldType.fielddataBuilder(fullyQualifiedIndexName, searchLookup);
        IndexFieldDataService indexFieldDataService = this;
        synchronized (indexFieldDataService) {
            cache = this.fieldDataCaches.get(fieldName);
            if (cache == null) {
                String cacheType = this.indexSettings.getValue(INDEX_FIELDDATA_CACHE_KEY);
                if (FIELDDATA_CACHE_VALUE_NODE.equals(cacheType)) {
                    cache = this.indicesFieldDataCache.buildIndexFieldDataCache(this.listener, this.index(), fieldName);
                } else if ("none".equals(cacheType)) {
                    cache = new IndexFieldDataCache.None();
                } else {
                    throw new IllegalArgumentException("cache type not supported [" + cacheType + "] for field [" + fieldName + "]");
                }
                this.fieldDataCaches.put(fieldName, cache);
            }
        }
        return (IFD)((IndexFieldData)builder.build(cache, this.circuitBreakerService));
    }

    public SortField getSortField(IndexSortConfig.FieldSortSpec sortSpec, Function<String, BaseMappedFieldType> fieldTypeLookup, boolean shouldWidenIndexSortType) {
        Object fieldData;
        String field = sortSpec.getField();
        SortOrder order = sortSpec.getOrder();
        MappedFieldType ft = (MappedFieldType)MappedFieldType.class.cast(fieldTypeLookup.apply(field));
        if (ft == null) {
            throw new IllegalArgumentException("unknown index sort field:[" + field + "]");
        }
        boolean reverse = order == null ? false : order == SortOrder.DESC;
        MultiValueMode mode = sortSpec.getMode();
        if (mode == null) {
            mode = reverse ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        try {
            fieldData = this.getForField(ft, this.index().getName(), () -> {
                throw new UnsupportedOperationException("index sorting not supported on runtime field [" + field + "]");
            });
        }
        catch (Exception e) {
            throw new IllegalArgumentException("docvalues not found for index sort field:[" + field + "]", e);
        }
        if (fieldData == null) {
            throw new IllegalArgumentException("docvalues not found for index sort field:[" + field + "]");
        }
        if (shouldWidenIndexSortType) {
            return fieldData.wideSortField(sortSpec.getMissingValue(), mode, null, reverse);
        }
        return fieldData.sortField(sortSpec.getMissingValue(), mode, null, reverse);
    }

    public void setListener(IndexFieldDataCache.Listener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        if (this.listener != DEFAULT_NOOP_LISTENER) {
            throw new IllegalStateException("can't set listener more than once");
        }
        this.listener = listener;
    }

    @Override
    public void close() throws IOException {
        this.clear();
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_FIELDDATA_CACHE_KEY);
        }
    }
}

