/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.core.index.fielddata.AbstractNumericDocValues;
import java.io.IOException;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;

public abstract class NumericDoubleValues
extends DoubleValues {
    protected NumericDoubleValues() {
    }

    public NumericDocValues getRawDoubleValues() {
        return new AbstractNumericDocValues(){
            private int docID = -1;

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            public long longValue() throws IOException {
                return Double.doubleToRawLongBits(NumericDoubleValues.this.doubleValue());
            }

            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int target) throws IOException {
                return NumericDoubleValues.this.advance(target);
            }
        };
    }

    public NumericDocValues getRawFloatValues() {
        return new AbstractNumericDocValues(){
            private int docID = -1;

            public boolean advanceExact(int target) throws IOException {
                this.docID = target;
                return NumericDoubleValues.this.advanceExact(target);
            }

            public long longValue() throws IOException {
                return Float.floatToRawIntBits((float)NumericDoubleValues.this.doubleValue());
            }

            public int docID() {
                return this.docID;
            }

            @Override
            public int advance(int target) throws IOException {
                return NumericDoubleValues.this.advance(target);
            }
        };
    }

    public int advance(int target) throws IOException {
        throw new UnsupportedOperationException();
    }
}

