/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.common.Numbers;
import io.skylite.core.common.time.DateUtils;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import java.math.BigInteger;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.function.UnaryOperator;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;

public abstract class ScriptDocValues<T>
extends AbstractList<T> {
    public abstract void setNextDocId(int var1) throws IOException;

    @Override
    public final void add(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final boolean remove(Object o) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void replaceAll(UnaryOperator<T> operator) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final T set(int index, T element) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    @Override
    public final void sort(Comparator<? super T> c) {
        throw new UnsupportedOperationException("doc values are unmodifiable");
    }

    public static final class UnsignedLongs
    extends ScriptDocValues<BigInteger> {
        private final SortedNumericDocValues in;
        private BigInteger[] values = new BigInteger[0];
        private int count;

        public UnsignedLongs(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = Numbers.toUnsignedBigInteger((long)this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = (BigInteger[])ArrayUtil.grow((Object[])this.values, (int)this.count);
        }

        public BigInteger getValue() {
            return this.get(0);
        }

        @Override
        public BigInteger get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class BytesRefs
    extends BinaryScriptDocValues<BytesRef> {
        public BytesRefs(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public BytesRef get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[index].toBytesRef();
        }

        public BytesRef getValue() {
            return this.get(0);
        }
    }

    public static class Strings
    extends BinaryScriptDocValues<String> {
        public Strings(SortedBinaryDocValues in) {
            super(in);
        }

        @Override
        public final String get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.bytesToString(this.values[index].get());
        }

        protected String bytesToString(BytesRef bytes) {
            return bytes.utf8ToString();
        }

        public final String getValue() {
            return this.get(0);
        }
    }

    static abstract class BinaryScriptDocValues<T>
    extends ScriptDocValues<T> {
        private final SortedBinaryDocValues in;
        protected BytesRefBuilder[] values = new BytesRefBuilder[0];
        protected int count;

        BinaryScriptDocValues(SortedBinaryDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i].copyBytes(this.in.nextValue());
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            if (newSize > this.values.length) {
                int oldLength = this.values.length;
                this.values = (BytesRefBuilder[])ArrayUtil.grow((Object[])this.values, (int)this.count);
                for (int i = oldLength; i < this.values.length; ++i) {
                    this.values[i] = new BytesRefBuilder();
                }
            }
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Booleans
    extends ScriptDocValues<Boolean> {
        private final SortedNumericDocValues in;
        private boolean[] values = new boolean[0];
        private int count;

        public Booleans(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue() == 1L;
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = Booleans.grow(this.values, this.count);
        }

        public boolean getValue() {
            return this.get(0);
        }

        @Override
        public Boolean get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        private static boolean[] grow(boolean[] array, int minSize) {
            assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
            if (array.length < minSize) {
                return Arrays.copyOf(array, ArrayUtil.oversize((int)minSize, (int)1));
            }
            return array;
        }
    }

    public static final class Doubles
    extends ScriptDocValues<Double> {
        private final SortedNumericDoubleValues in;
        private double[] values = new double[0];
        private int count;

        public Doubles(SortedNumericDoubleValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow((double[])this.values, (int)this.count);
        }

        public SortedNumericDoubleValues getInternalValues() {
            return this.in;
        }

        public double getValue() {
            return this.get(0);
        }

        @Override
        public Double get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }

    public static final class Dates
    extends ScriptDocValues<ZonedDateTime> {
        private final SortedNumericDocValues in;
        private final boolean isNanos;
        private ZonedDateTime[] dates;
        private int count;

        public Dates(SortedNumericDocValues in, boolean isNanos) {
            this.in = in;
            this.isNanos = isNanos;
        }

        public ZonedDateTime getValue() {
            return this.get(0);
        }

        @Override
        public ZonedDateTime get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            if (index >= this.count) {
                throw new IndexOutOfBoundsException("attempted to fetch the [" + index + "] date when there are only [" + this.count + "] dates.");
            }
            return this.dates[index];
        }

        @Override
        public int size() {
            return this.count;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            this.count = this.in.advanceExact(docId) ? this.in.docValueCount() : 0;
            this.refreshArray();
        }

        void refreshArray() throws IOException {
            if (this.count == 0) {
                return;
            }
            if (this.dates == null || this.count > this.dates.length) {
                this.dates = new ZonedDateTime[this.count];
            }
            for (int i = 0; i < this.count; ++i) {
                this.dates[i] = this.isNanos ? ZonedDateTime.ofInstant(DateUtils.toInstant(this.in.nextValue()), ZoneOffset.UTC) : ZonedDateTime.ofInstant(Instant.ofEpochMilli(this.in.nextValue()), ZoneOffset.UTC);
            }
        }
    }

    public static final class Longs
    extends ScriptDocValues<Long> {
        private final SortedNumericDocValues in;
        private long[] values = new long[0];
        private int count;

        public Longs(SortedNumericDocValues in) {
            this.in = in;
        }

        @Override
        public void setNextDocId(int docId) throws IOException {
            if (this.in.advanceExact(docId)) {
                this.resize(this.in.docValueCount());
                for (int i = 0; i < this.count; ++i) {
                    this.values[i] = this.in.nextValue();
                }
            } else {
                this.resize(0);
            }
        }

        protected void resize(int newSize) {
            this.count = newSize;
            this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
        }

        public long getValue() {
            return this.get(0);
        }

        @Override
        public Long get(int index) {
            if (this.count == 0) {
                throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
            }
            return this.values[index];
        }

        @Override
        public int size() {
            return this.count;
        }
    }
}

