/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata;

import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Sorter;

public abstract class SortingBinaryDocValues
extends SortedBinaryDocValues {
    private int index;
    protected int count;
    protected BytesRefBuilder[] values = new BytesRefBuilder[]{new BytesRefBuilder()};
    private final Sorter sorter = new InPlaceMergeSorter(){

        protected void swap(int i, int j) {
            ArrayUtil.swap((Object[])SortingBinaryDocValues.this.values, (int)i, (int)j);
        }

        protected int compare(int i, int j) {
            return SortingBinaryDocValues.this.values[i].get().compareTo(SortingBinaryDocValues.this.values[j].get());
        }
    };

    protected SortingBinaryDocValues() {
    }

    protected final void grow() {
        if (this.values.length < this.count) {
            int oldLen = this.values.length;
            int newLen = ArrayUtil.oversize((int)this.count, (int)RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            this.values = Arrays.copyOf(this.values, newLen);
            for (int i = oldLen; i < newLen; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
        this.index = 0;
    }

    @Override
    public int docValueCount() {
        return this.count;
    }

    @Override
    public final BytesRef nextValue() {
        assert (this.index < this.count);
        return this.values[this.index++].get();
    }
}

