/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.fieldcomparator;

import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.IndexNumericFieldData;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.NumericDoubleValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import io.skylite.core.index.fielddata.fieldcomparator.FloatValuesComparatorSource;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.comparators.HalfFloatComparator;
import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.util.BitSet;

public class HalfFloatValuesComparatorSource
extends FloatValuesComparatorSource {
    private final IndexNumericFieldData indexFieldData;

    public HalfFloatValuesComparatorSource(IndexNumericFieldData indexFieldData, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested) {
        super(indexFieldData, missingValue, sortMode, nested);
        this.indexFieldData = indexFieldData;
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, Pruning pruning, boolean reversed) {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        final float fMissingValue = ((Float)this.missingObject(this.missingValue, reversed)).floatValue();
        return new HalfFloatComparator(numHits, fieldname, null, reversed, this.filterPruning(pruning)){

            @Override
            public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
                return new HalfFloatComparator.HalfFloatLeafComparator(context){

                    protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
                        return HalfFloatValuesComparatorSource.this.getNumericDocValues(context, fMissingValue).getRawFloatValues();
                    }
                };
            }
        };
    }

    private NumericDoubleValues getNumericDocValues(LeafReaderContext context, float missingValue) throws IOException {
        SortedNumericDoubleValues values = ((LeafNumericFieldData)this.indexFieldData.load(context)).getDoubleValues();
        if (this.nested == null) {
            return FieldData.replaceMissing(this.sortMode.select(values), missingValue);
        }
        BitSet rootDocs = this.nested.rootDocs(context);
        DocIdSetIterator innerDocs = this.nested.innerDocs(context);
        int maxChildren = this.nested.getNestedSort() != null ? this.nested.getNestedSort().getMaxChildren() : Integer.MAX_VALUE;
        return this.sortMode.select(values, missingValue, rootDocs, innerDocs, context.reader().maxDoc(), maxChildren);
    }
}

