/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.fieldcomparator;

import io.skylite.common.Numbers;
import java.io.IOException;
import java.math.BigInteger;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.LeafFieldComparator;
import org.apache.lucene.search.Pruning;
import org.apache.lucene.search.comparators.NumericComparator;
import org.apache.lucene.util.NumericUtils;

public class UnsignedLongComparator
extends NumericComparator<BigInteger> {
    private final BigInteger[] values;
    protected BigInteger topValue;
    protected BigInteger bottom;

    public UnsignedLongComparator(int numHits, String field, BigInteger missingValue, boolean reverse, Pruning pruning) {
        super(field, (Number)(missingValue != null ? missingValue : Numbers.MIN_UNSIGNED_LONG_VALUE), reverse, pruning, 16);
        this.values = new BigInteger[numHits];
    }

    public int compare(int slot1, int slot2) {
        return this.values[slot1].compareTo(this.values[slot2]);
    }

    public void setTopValue(BigInteger value) {
        super.setTopValue((Number)value);
        this.topValue = value;
    }

    protected long missingValueAsComparableLong() {
        return ((BigInteger)this.missingValue).longValueExact();
    }

    protected long sortableBytesToLong(byte[] bytes) {
        return NumericUtils.sortableBytesToLong((byte[])bytes, (int)0);
    }

    public BigInteger value(int slot) {
        return this.values[slot];
    }

    public LeafFieldComparator getLeafComparator(LeafReaderContext context) throws IOException {
        return new UnsignedLongLeafComparator(context);
    }

    public class UnsignedLongLeafComparator
    extends NumericComparator.NumericLeafComparator {
        public UnsignedLongLeafComparator(LeafReaderContext context) throws IOException {
            super((NumericComparator)UnsignedLongComparator.this, context);
        }

        private BigInteger getValueForDoc(int doc) throws IOException {
            if (this.docValues.advanceExact(doc)) {
                return Numbers.toUnsignedBigInteger((long)this.docValues.longValue());
            }
            return (BigInteger)UnsignedLongComparator.this.missingValue;
        }

        public void setBottom(int slot) throws IOException {
            UnsignedLongComparator.this.bottom = UnsignedLongComparator.this.values[slot];
            super.setBottom(slot);
        }

        public int compareBottom(int doc) throws IOException {
            return UnsignedLongComparator.this.bottom.compareTo(this.getValueForDoc(doc));
        }

        public int compareTop(int doc) throws IOException {
            return UnsignedLongComparator.this.topValue.compareTo(this.getValueForDoc(doc));
        }

        public void copy(int slot, int doc) throws IOException {
            UnsignedLongComparator.this.values[slot] = this.getValueForDoc(doc);
            super.copy(slot, doc);
        }

        protected long bottomAsComparableLong() {
            return this.bigIntegerToComparableLong(UnsignedLongComparator.this.bottom);
        }

        protected long topAsComparableLong() {
            return this.bigIntegerToComparableLong(UnsignedLongComparator.this.topValue);
        }

        private long bigIntegerToComparableLong(BigInteger value) {
            if (value.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0) {
                return value.longValueExact();
            }
            return value.subtract(BigInteger.valueOf(1L).shiftLeft(64)).longValueExact();
        }
    }
}

