/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.geo;

import io.skylite.common.geometry.Geometry;
import io.skylite.core.geo.GeoShapeDocValue;
import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.util.BytesRef;

public abstract class GeoShapeValue {
    protected GeoShapeValue() {
    }

    public abstract boolean advanceExact(int var1) throws IOException;

    public abstract GeoShapeDocValue nextValue() throws IOException;

    public static class StandardGeoShapeValue
    extends GeoShapeValue {
        private final BinaryDocValues binaryDocValues;
        private final String fieldName;

        public StandardGeoShapeValue(BinaryDocValues binaryDocValues, String fieldName) {
            this.binaryDocValues = binaryDocValues;
            this.fieldName = fieldName;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            return this.binaryDocValues.advanceExact(doc);
        }

        @Override
        public GeoShapeDocValue nextValue() throws IOException {
            BytesRef bytesRef = this.binaryDocValues.binaryValue();
            return new GeoShapeDocValue(this.fieldName, bytesRef);
        }
    }

    public static class MissingGeoShapeValue
    extends GeoShapeValue {
        private boolean useMissingGeoShapeValue;
        private final GeoShapeValue valueSourceData;
        private final Geometry missing;
        private GeoShapeDocValue geoShapeDocValue;

        public MissingGeoShapeValue(GeoShapeValue valueSourceData, Geometry missing) {
            this.missing = missing;
            this.valueSourceData = valueSourceData;
            this.useMissingGeoShapeValue = false;
        }

        @Override
        public boolean advanceExact(int doc) throws IOException {
            this.useMissingGeoShapeValue = !this.valueSourceData.advanceExact(doc);
            return true;
        }

        @Override
        public GeoShapeDocValue nextValue() throws IOException {
            if (this.useMissingGeoShapeValue) {
                if (this.geoShapeDocValue == null) {
                    this.geoShapeDocValue = GeoShapeDocValue.createGeometryDocValue(this.missing);
                }
                return this.geoShapeDocValue;
            }
            return this.valueSourceData.nextValue();
        }
    }

    public static class EmptyGeoShapeValue
    extends GeoShapeValue {
        @Override
        public boolean advanceExact(int doc) throws IOException {
            return false;
        }

        @Override
        public GeoShapeDocValue nextValue() throws IOException {
            throw new UnsupportedOperationException("This empty geoShape value, hence this operation is not supported");
        }
    }
}

