/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.ordinals;

import io.skylite.SkyliteException;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexOrdinalsFieldData;
import io.skylite.core.index.fielddata.LeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.ordinals.AbstractLeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.ordinals.GlobalOrdinalsBuilder;
import io.skylite.core.index.fielddata.ordinals.GlobalOrdinalsIndexFieldData;
import io.skylite.core.index.fielddata.plain.AbstractBinaryDVLeafFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import java.io.IOException;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;

public abstract class AbstractIndexOrdinalsFieldData
implements IndexOrdinalsFieldData {
    private static final Logger logger = LogManager.getLogger(AbstractBinaryDVLeafFieldData.class);
    private final String fieldName;
    private final ValuesSourceType valuesSourceType;
    private final IndexFieldDataCache cache;
    protected final CircuitBreakerService breakerService;
    protected final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;

    protected AbstractIndexOrdinalsFieldData(String fieldName, ValuesSourceType valuesSourceType, IndexFieldDataCache cache, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        this.fieldName = fieldName;
        this.valuesSourceType = valuesSourceType;
        this.cache = cache;
        this.breakerService = breakerService;
        this.scriptFunction = scriptFunction;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public ValuesSourceType getValuesSourceType() {
        return this.valuesSourceType;
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }

    @Override
    public LeafOrdinalsFieldData load(LeafReaderContext context) {
        if (context.reader().getFieldInfos().fieldInfo(this.fieldName) == null) {
            return AbstractLeafOrdinalsFieldData.empty();
        }
        try {
            return (LeafOrdinalsFieldData)this.cache.load(context, this);
        }
        catch (Exception e) {
            if (e instanceof SkyliteException) {
                throw (SkyliteException)e;
            }
            throw new SkyliteException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        IndexOrdinalsFieldData fieldData = this.loadGlobalInternal(indexReader);
        if (fieldData instanceof GlobalOrdinalsIndexFieldData) {
            return ((GlobalOrdinalsIndexFieldData)fieldData).newConsumer(indexReader);
        }
        return fieldData;
    }

    private IndexOrdinalsFieldData loadGlobalInternal(DirectoryReader indexReader) {
        if (indexReader.leaves().size() <= 1) {
            return this;
        }
        boolean fieldFound = false;
        for (LeafReaderContext context : indexReader.leaves()) {
            if (context.reader().getFieldInfos().fieldInfo(this.getFieldName()) == null) continue;
            fieldFound = true;
            break;
        }
        if (!fieldFound) {
            try {
                return GlobalOrdinalsBuilder.buildEmpty((IndexReader)indexReader, this);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            return this.cache.load(indexReader, this);
        }
        catch (Exception e) {
            if (e instanceof SkyliteException) {
                throw (SkyliteException)e;
            }
            throw new SkyliteException(e);
        }
    }

    @Override
    public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) throws Exception {
        return GlobalOrdinalsBuilder.build((IndexReader)indexReader, this, this.breakerService, logger, this.scriptFunction);
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return false;
    }

    public static interface PerValueEstimator {
        public long bytesPerValue(BytesRef var1);

        public TermsEnum beforeLoad(Terms var1) throws IOException;

        public void afterLoad(TermsEnum var1, long var2);
    }
}

