/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.ordinals;

import io.skylite.core.index.fielddata.AbstractSortedDocValues;
import io.skylite.core.index.fielddata.AbstractSortedSetDocValues;
import io.skylite.core.index.fielddata.ordinals.Ordinals;
import io.skylite.core.index.fielddata.ordinals.OrdinalsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongsRef;
import org.apache.lucene.util.packed.PackedInts;
import org.apache.lucene.util.packed.PackedLongValues;

public class MultiOrdinals
extends Ordinals {
    private static final int OFFSETS_PAGE_SIZE = 1024;
    private final boolean multiValued;
    private final long valueCount;
    private final PackedLongValues endOffsets;
    private final PackedLongValues ords;

    public static boolean significantlySmallerThanSinglePackedOrdinals(int maxDoc, int numDocsWithValue, long numOrds, float acceptableOverheadRatio) {
        long expectedSingleSizeInBytes;
        int bitsPerOrd = PackedInts.bitsRequired((long)numOrds);
        bitsPerOrd = PackedInts.fastestFormatAndBits((int)numDocsWithValue, (int)bitsPerOrd, (float)acceptableOverheadRatio).bitsPerValue();
        float avgValuesPerDoc = (float)numDocsWithValue / (float)maxDoc;
        int maxDelta = (int)Math.ceil(1024.0f * (1.0f - avgValuesPerDoc) * avgValuesPerDoc);
        int bitsPerOffset = PackedInts.bitsRequired((long)maxDelta) + 1;
        long expectedMultiSizeInBytes = (long)numDocsWithValue * (long)bitsPerOrd + (long)maxDoc * (long)(bitsPerOffset = PackedInts.fastestFormatAndBits((int)maxDoc, (int)bitsPerOffset, (float)acceptableOverheadRatio).bitsPerValue());
        return (float)expectedMultiSizeInBytes < 0.8f * (float)(expectedSingleSizeInBytes = (long)maxDoc * (long)bitsPerOrd);
    }

    public MultiOrdinals(OrdinalsBuilder builder, float acceptableOverheadRatio) {
        this.multiValued = builder.getNumMultiValuesDocs() > 0;
        this.valueCount = builder.getValueCount();
        PackedLongValues.Builder endOffsetsBuilder = PackedLongValues.monotonicBuilder((int)1024, (float)acceptableOverheadRatio);
        PackedLongValues.Builder ordsBuilder = PackedLongValues.packedBuilder((int)1024, (float)acceptableOverheadRatio);
        long lastEndOffset = 0L;
        for (int i = 0; i < builder.maxDoc(); ++i) {
            LongsRef docOrds = builder.docOrds(i);
            long endOffset = lastEndOffset + (long)docOrds.length;
            endOffsetsBuilder.add(endOffset);
            for (int j = 0; j < docOrds.length; ++j) {
                ordsBuilder.add(docOrds.longs[docOrds.offset + j]);
            }
            lastEndOffset = endOffset;
        }
        this.endOffsets = endOffsetsBuilder.build();
        this.ords = ordsBuilder.build();
        assert (this.endOffsets.size() == (long)builder.maxDoc());
        assert (this.ords.size() == (long)builder.getTotalNumOrds()) : this.ords.size() + " != " + builder.getTotalNumOrds();
    }

    @Override
    public long ramBytesUsed() {
        return this.endOffsets.ramBytesUsed() + this.ords.ramBytesUsed();
    }

    public Collection<Accountable> getChildResources() {
        ArrayList<Accountable> resources = new ArrayList<Accountable>();
        resources.add(Accountables.namedAccountable((String)"offsets", (Accountable)this.endOffsets));
        resources.add(Accountables.namedAccountable((String)"ordinals", (Accountable)this.ords));
        return Collections.unmodifiableCollection(resources);
    }

    @Override
    public SortedSetDocValues ordinals(Ordinals.ValuesHolder values) {
        if (this.multiValued) {
            return new MultiDocs(this, values);
        }
        return DocValues.singleton((SortedDocValues)new SingleDocs(this, values));
    }

    private static class MultiDocs
    extends AbstractSortedSetDocValues {
        private final long valueCount;
        private final PackedLongValues endOffsets;
        private final PackedLongValues ords;
        private final Ordinals.ValuesHolder values;
        private long currentOffset;
        private long currentEndOffset;
        private int count;

        MultiDocs(MultiOrdinals ordinals, Ordinals.ValuesHolder values) {
            this.valueCount = ordinals.valueCount;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.values = values;
        }

        public long getValueCount() {
            return this.valueCount;
        }

        public boolean advanceExact(int docId) throws IOException {
            this.currentOffset = docId != 0 ? this.endOffsets.get((long)(docId - 1)) : 0L;
            this.currentEndOffset = this.endOffsets.get((long)docId);
            this.count = Math.toIntExact(this.currentEndOffset - this.currentOffset);
            return this.currentOffset != this.currentEndOffset;
        }

        public long nextOrd() throws IOException {
            assert (this.currentOffset != this.currentEndOffset);
            return this.ords.get(this.currentOffset++);
        }

        public BytesRef lookupOrd(long ord) {
            return this.values.lookupOrd(ord);
        }

        public int docValueCount() {
            return this.count;
        }
    }

    private static class SingleDocs
    extends AbstractSortedDocValues {
        private final int valueCount;
        private final PackedLongValues endOffsets;
        private final PackedLongValues ords;
        private final Ordinals.ValuesHolder values;
        private int currentDoc = -1;
        private long currentStartOffset;
        private long currentEndOffset;

        SingleDocs(MultiOrdinals ordinals, Ordinals.ValuesHolder values) {
            this.valueCount = (int)ordinals.valueCount;
            this.endOffsets = ordinals.endOffsets;
            this.ords = ordinals.ords;
            this.values = values;
        }

        public int ordValue() {
            return (int)this.ords.get(this.currentStartOffset);
        }

        public boolean advanceExact(int docId) throws IOException {
            this.currentDoc = docId;
            this.currentStartOffset = docId != 0 ? this.endOffsets.get((long)(docId - 1)) : 0L;
            this.currentEndOffset = this.endOffsets.get((long)docId);
            return this.currentStartOffset != this.currentEndOffset;
        }

        public int docID() {
            return this.currentDoc;
        }

        public BytesRef lookupOrd(int ord) {
            return this.values.lookupOrd(ord);
        }

        public int getValueCount() {
            return this.valueCount;
        }
    }
}

