/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.AbstractSortedDocValues;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.IndexOrdinalsFieldData;
import io.skylite.core.index.fielddata.LeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import io.skylite.core.index.fielddata.ordinals.AbstractIndexOrdinalsFieldData;
import io.skylite.core.index.fielddata.ordinals.AbstractLeafOrdinalsFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.BytesRef;

public class ConstantIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    private final ConstantLeafFieldData atomicFieldData;

    private ConstantIndexFieldData(String name, String value, ValuesSourceType valuesSourceType) {
        super(name, valuesSourceType, null, null, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
        this.atomicFieldData = new ConstantLeafFieldData(value);
    }

    @Override
    public final LeafOrdinalsFieldData load(LeafReaderContext context) {
        return this.atomicFieldData;
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
        return this.atomicFieldData;
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public IndexOrdinalsFieldData loadGlobal(DirectoryReader indexReader) {
        return this;
    }

    @Override
    public IndexOrdinalsFieldData loadGlobalDirect(DirectoryReader indexReader) {
        return this.loadGlobal(indexReader);
    }

    public String getValue() {
        return this.atomicFieldData.value;
    }

    private static class ConstantLeafFieldData
    extends AbstractLeafOrdinalsFieldData {
        private final String value;

        ConstantLeafFieldData(String value) {
            super(AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION);
            this.value = value;
        }

        public long ramBytesUsed() {
            return 0L;
        }

        public Collection<Accountable> getChildResources() {
            return Collections.emptyList();
        }

        @Override
        public SortedSetDocValues getOrdinalsValues() {
            if (this.value == null) {
                return DocValues.emptySortedSet();
            }
            final BytesRef term = new BytesRef((CharSequence)this.value);
            AbstractSortedDocValues sortedValues = new AbstractSortedDocValues(this){
                private int docID = -1;

                public BytesRef lookupOrd(int ord) {
                    return term;
                }

                public int getValueCount() {
                    return 1;
                }

                public int ordValue() {
                    return 0;
                }

                public boolean advanceExact(int target) {
                    this.docID = target;
                    return true;
                }

                public int docID() {
                    return this.docID;
                }
            };
            return DocValues.singleton((SortedDocValues)sortedValues);
        }

        public void close() {
        }
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String constantValue;
        private final String name;
        private final ValuesSourceType valuesSourceType;

        public Builder(String constantValue, String name, ValuesSourceType valuesSourceType) {
            this.constantValue = constantValue;
            this.name = name;
            this.valuesSourceType = valuesSourceType;
        }

        public IndexFieldData<?> build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new ConstantIndexFieldData(this.name, this.constantValue, this.valuesSourceType);
        }
    }
}

