/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.FieldData;
import io.skylite.core.index.fielddata.FormattedDocValuesLoader;
import io.skylite.core.index.fielddata.LeafNumericFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.SortedBinaryDocValues;
import io.skylite.core.index.fielddata.SortedNumericDoubleValues;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.Accountable;

public abstract class LeafDoubleFieldData
implements LeafNumericFieldData {
    private final long ramBytesUsed;

    protected LeafDoubleFieldData(long ramBytesUsed) {
        this.ramBytesUsed = ramBytesUsed;
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    public final ScriptDocValues<Double> getScriptValues() {
        return new ScriptDocValues.Doubles(this.getDoubleValues());
    }

    @Override
    public final SortedBinaryDocValues getBytesValues() {
        return FieldData.toString(this.getDoubleValues());
    }

    @Override
    public final SortedNumericDocValues getLongValues() {
        return FieldData.castToLong(this.getDoubleValues());
    }

    public static LeafNumericFieldData empty(int maxDoc) {
        return new LeafDoubleFieldData(0L){

            @Override
            public SortedNumericDoubleValues getDoubleValues() {
                return FieldData.emptySortedNumericDoubles();
            }

            public Collection<Accountable> getChildResources() {
                return Collections.emptyList();
            }
        };
    }

    @Override
    public FormattedDocValuesLoader loadFormattedDocValues(final DocValueFormat format) {
        final SortedNumericDoubleValues values = this.getDoubleValues();
        return new FormattedDocValuesLoader(){

            @Override
            public boolean advanceExact(int docId) throws IOException {
                return values.advanceExact(docId);
            }

            @Override
            public int docValueCount() throws IOException {
                return values.docValueCount();
            }

            @Override
            public Object nextValue() throws IOException {
                return format.format(values.nextValue());
            }
        };
    }

    public void close() {
    }
}

