/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.fielddata.plain;

import io.skylite.common.Nullable;
import io.skylite.core.aggregations.values.ValuesSourceType;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.DocValueFormat;
import io.skylite.core.index.fielddata.IndexFieldDataCache;
import io.skylite.core.index.fielddata.IndexFieldDataFieldComparatorSource;
import io.skylite.core.index.fielddata.LeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.ScriptDocValues;
import io.skylite.core.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import io.skylite.core.index.fielddata.ordinals.AbstractIndexOrdinalsFieldData;
import io.skylite.core.index.fielddata.ordinals.AbstractLeafOrdinalsFieldData;
import io.skylite.core.index.fielddata.plain.SortedSetBytesLeafFieldData;
import io.skylite.core.indices.breaker.CircuitBreakerService;
import io.skylite.core.search.MultiValueMode;
import io.skylite.core.search.sort.BucketedSort;
import io.skylite.core.search.sort.SortOrder;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.OrdinalMap;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSelector;
import org.apache.lucene.search.SortedSetSortField;

public class SortedSetOrdinalsIndexFieldData
extends AbstractIndexOrdinalsFieldData {
    public SortedSetOrdinalsIndexFieldData(IndexFieldDataCache cache, String fieldName, ValuesSourceType valuesSourceType, CircuitBreakerService breakerService, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction) {
        super(fieldName, valuesSourceType, cache, breakerService, scriptFunction);
    }

    @Override
    public SortField sortField(@Nullable Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, boolean reverse) {
        BytesRefFieldComparatorSource source = new BytesRefFieldComparatorSource(this, missingValue, sortMode, nested);
        if (nested != null || sortMode != MultiValueMode.MAX && sortMode != MultiValueMode.MIN || !source.sortMissingLast(missingValue) && !source.sortMissingFirst(missingValue)) {
            return new SortField(this.getFieldName(), (FieldComparatorSource)source, reverse);
        }
        SortedSetSortField sortField = new SortedSetSortField(this.getFieldName(), reverse, sortMode == MultiValueMode.MAX ? SortedSetSelector.Type.MAX : SortedSetSelector.Type.MIN);
        sortField.setMissingValue(source.sortMissingLast(missingValue) ^ reverse ? SortedSetSortField.STRING_LAST : SortedSetSortField.STRING_FIRST);
        return sortField;
    }

    @Override
    public BucketedSort newBucketedSort(BigArrays bigArrays, Object missingValue, MultiValueMode sortMode, IndexFieldDataFieldComparatorSource.Nested nested, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
        throw new IllegalArgumentException("only supported on numeric fields");
    }

    @Override
    public LeafOrdinalsFieldData load(LeafReaderContext context) {
        return new SortedSetBytesLeafFieldData(context.reader(), this.getFieldName(), this.scriptFunction);
    }

    @Override
    public LeafOrdinalsFieldData loadDirect(LeafReaderContext context) {
        return this.load(context);
    }

    @Override
    public OrdinalMap getOrdinalMap() {
        return null;
    }

    @Override
    public boolean supportsGlobalOrdinalsMapping() {
        return true;
    }

    public static class Builder
    implements BaseIndexFieldData.Builder {
        private final String name;
        private final Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction;
        private final ValuesSourceType valuesSourceType;

        public Builder(String name, ValuesSourceType valuesSourceType) {
            this(name, AbstractLeafOrdinalsFieldData.DEFAULT_SCRIPT_FUNCTION, valuesSourceType);
        }

        public Builder(String name, Function<SortedSetDocValues, ScriptDocValues<?>> scriptFunction, ValuesSourceType valuesSourceType) {
            this.name = name;
            this.scriptFunction = scriptFunction;
            this.valuesSourceType = valuesSourceType;
        }

        public SortedSetOrdinalsIndexFieldData build(IndexFieldDataCache cache, CircuitBreakerService breakerService) {
            return new SortedSetOrdinalsIndexFieldData(cache, this.name, this.valuesSourceType, breakerService, this.scriptFunction);
        }
    }
}

