/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.pressure;

import io.skylite.common.lease.Releasable;
import io.skylite.core.action.admin.indices.stats.CommonStatsFlags;
import io.skylite.core.index.pressure.IndexingPressureStats;
import io.skylite.core.index.pressure.ShardIndexingPressure;
import io.skylite.core.index.pressure.ShardIndexingPressureStats;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Settings;
import java.util.function.LongSupplier;

public class IndexingPressureService {
    private final ShardIndexingPressure shardIndexingPressure;

    public IndexingPressureService(Settings settings, ClusterSettings clusterSettings) {
        this.shardIndexingPressure = new ShardIndexingPressure(settings, clusterSettings);
    }

    public Releasable markCoordinatingOperationStarted(LongSupplier bytes, boolean forceExecution) {
        if (!this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markCoordinatingOperationStarted(bytes.getAsLong(), forceExecution);
        }
        return () -> {};
    }

    public Releasable markCoordinatingOperationStarted(ShardId shardId, LongSupplier bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markCoordinatingOperationStarted(shardId, bytes.getAsLong(), forceExecution);
        }
        return () -> {};
    }

    public Releasable markPrimaryOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markPrimaryOperationStarted(shardId, bytes, forceExecution);
        }
        return this.shardIndexingPressure.markPrimaryOperationStarted(bytes, forceExecution);
    }

    public Releasable markPrimaryOperationLocalToCoordinatingNodeStarted(ShardId shardId, long bytes) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(shardId, bytes);
        }
        return this.shardIndexingPressure.markPrimaryOperationLocalToCoordinatingNodeStarted(bytes);
    }

    public Releasable markReplicaOperationStarted(ShardId shardId, long bytes, boolean forceExecution) {
        if (this.isShardIndexingPressureEnabled()) {
            return this.shardIndexingPressure.markReplicaOperationStarted(shardId, bytes, forceExecution);
        }
        return this.shardIndexingPressure.markReplicaOperationStarted(bytes, forceExecution);
    }

    public IndexingPressureStats nodeStats() {
        return this.shardIndexingPressure.stats();
    }

    public ShardIndexingPressureStats shardStats(CommonStatsFlags statsFlags) {
        return this.shardIndexingPressure.shardStats(statsFlags);
    }

    private boolean isShardIndexingPressureEnabled() {
        return this.shardIndexingPressure.isShardIndexingPressureEnabled();
    }

    ShardIndexingPressure getShardIndexingPressure() {
        return this.shardIndexingPressure;
    }
}

