/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.pressure;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.List;

public final class ShardIndexingPressureSettings {
    public static final String SHARD_INDEXING_PRESSURE_ENABLED_ATTRIBUTE_KEY = "shard_indexing_pressure_enabled";
    public static final Setting<Boolean> SHARD_INDEXING_PRESSURE_ENABLED = Setting.boolSetting("shard_indexing_pressure.enabled", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Boolean> SHARD_INDEXING_PRESSURE_ENFORCED = Setting.boolSetting("shard_indexing_pressure.enforced", false, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<Integer> REQUEST_SIZE_WINDOW = Setting.intSetting("shard_indexing_pressure.secondary_parameter.throughput.request_size_window", 2000, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> SHARD_MIN_LIMIT = Setting.doubleSetting("shard_indexing_pressure.primary_parameter.shard.min_limit", 0.001, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> LOWER_OPERATING_FACTOR = Setting.doubleSetting("shard_indexing_pressure.operating_factor.lower", 0.75, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> OPTIMAL_OPERATING_FACTOR = Setting.doubleSetting("shard_indexing_pressure.operating_factor.optimal", 0.85, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> UPPER_OPERATING_FACTOR = Setting.doubleSetting("shard_indexing_pressure.operating_factor.upper", 0.95, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> SUCCESSFUL_REQUEST_ELAPSED_TIMEOUT = Setting.positiveTimeSetting("shard_indexing_pressure.secondary_parameter.successful_request.elapsed_timeout", TimeValue.timeValueMillis((long)300000L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> MAX_OUTSTANDING_REQUESTS = Setting.intSetting("shard_indexing_pressure.secondary_parameter.successful_request.max_outstanding_requests", 100, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> THROUGHPUT_DEGRADATION_LIMITS = Setting.doubleSetting("shard_indexing_pressure.secondary_parameter.throughput.degradation_factor", 5.0, 1.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Double> NODE_SOFT_LIMIT = Setting.doubleSetting("shard_indexing_pressure.primary_parameter.node.soft_limit", 0.7, 0.0, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> MAX_COLD_STORE_SIZE = Setting.intSetting("shard_indexing_pressure.cache_store.max_size", 200, 100, 1000, Setting.Property.NodeScope, Setting.Property.Dynamic);
    private volatile boolean shardIndexingPressureEnabled;
    private volatile boolean shardIndexingPressureEnforced;
    private volatile long shardPrimaryAndCoordinatingBaseLimits;
    private volatile long shardReplicaBaseLimits;
    private volatile int requestSizeWindow;
    private volatile double shardMinLimit;
    private final long primaryAndCoordinatingNodeLimits;

    public ShardIndexingPressureSettings(ClusterSettings clusterSettings, Settings settings, long primaryAndCoordinatingLimits) {
        this.shardIndexingPressureEnabled = SHARD_INDEXING_PRESSURE_ENABLED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SHARD_INDEXING_PRESSURE_ENABLED, this::setShardIndexingPressureEnabled);
        this.shardIndexingPressureEnforced = SHARD_INDEXING_PRESSURE_ENFORCED.get(settings);
        clusterSettings.addSettingsUpdateConsumer(SHARD_INDEXING_PRESSURE_ENFORCED, this::setShardIndexingPressureEnforced);
        this.requestSizeWindow = REQUEST_SIZE_WINDOW.get(settings);
        clusterSettings.addSettingsUpdateConsumer(REQUEST_SIZE_WINDOW, this::setRequestSizeWindow);
        this.primaryAndCoordinatingNodeLimits = primaryAndCoordinatingLimits;
        this.shardMinLimit = SHARD_MIN_LIMIT.get(settings).floatValue();
        this.shardPrimaryAndCoordinatingBaseLimits = (long)((double)primaryAndCoordinatingLimits * this.shardMinLimit);
        this.shardReplicaBaseLimits = (long)((double)this.shardPrimaryAndCoordinatingBaseLimits * 1.5);
        clusterSettings.addSettingsUpdateConsumer(SHARD_MIN_LIMIT, this::setShardMinLimit);
    }

    private void setShardIndexingPressureEnabled(Boolean shardIndexingPressureEnableValue) {
        this.shardIndexingPressureEnabled = shardIndexingPressureEnableValue;
    }

    private void setShardIndexingPressureEnforced(Boolean shardIndexingPressureEnforcedValue) {
        this.shardIndexingPressureEnforced = shardIndexingPressureEnforcedValue;
    }

    private void setRequestSizeWindow(int requestSizeWindow) {
        this.requestSizeWindow = requestSizeWindow;
    }

    private void setShardMinLimit(double shardMinLimit) {
        this.shardMinLimit = shardMinLimit;
        this.setShardPrimaryAndCoordinatingBaseLimits();
        this.setShardReplicaBaseLimits();
    }

    private void setShardPrimaryAndCoordinatingBaseLimits() {
        this.shardPrimaryAndCoordinatingBaseLimits = (long)((double)this.primaryAndCoordinatingNodeLimits * this.shardMinLimit);
    }

    private void setShardReplicaBaseLimits() {
        this.shardReplicaBaseLimits = (long)((double)this.shardPrimaryAndCoordinatingBaseLimits * 1.5);
    }

    public boolean isShardIndexingPressureEnabled() {
        return this.shardIndexingPressureEnabled;
    }

    public boolean isShardIndexingPressureEnforced() {
        return this.shardIndexingPressureEnforced;
    }

    public int getRequestSizeWindow() {
        return this.requestSizeWindow;
    }

    public long getShardPrimaryAndCoordinatingBaseLimits() {
        return this.shardPrimaryAndCoordinatingBaseLimits;
    }

    public long getShardReplicaBaseLimits() {
        return this.shardReplicaBaseLimits;
    }

    public long getNodePrimaryAndCoordinatingLimits() {
        return this.primaryAndCoordinatingNodeLimits;
    }

    public long getNodeReplicaLimits() {
        return (long)((double)this.primaryAndCoordinatingNodeLimits * 1.5);
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(SHARD_INDEXING_PRESSURE_ENABLED, SHARD_INDEXING_PRESSURE_ENFORCED, REQUEST_SIZE_WINDOW, SHARD_MIN_LIMIT, MAX_COLD_STORE_SIZE, LOWER_OPERATING_FACTOR, OPTIMAL_OPERATING_FACTOR, UPPER_OPERATING_FACTOR, NODE_SOFT_LIMIT, THROUGHPUT_DEGRADATION_LIMITS, SUCCESSFUL_REQUEST_ELAPSED_TIMEOUT, MAX_OUTSTANDING_REQUESTS);
        }
    }
}

