/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.common.SetOnce;
import io.skylite.core.index.query.CheckedQueryBuilderVisitor;
import io.skylite.core.index.query.QueryBuilder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.BooleanClause;

public abstract class CheckedQueryShapeVisitor<V extends CheckedQueryBuilderVisitor<V, R, E>, R, E extends Exception>
implements CheckedQueryBuilderVisitor<V, R, E> {
    private final SetOnce<String> queryType = new SetOnce();
    protected final Map<BooleanClause.Occur, List<V>> childVisitors = new EnumMap<BooleanClause.Occur, List<V>>(BooleanClause.Occur.class);

    @Override
    public R accept(QueryBuilder qb) throws E {
        this.queryType.set((Object)qb.getName());
        return this.visit(qb);
    }

    @Override
    public V getChildVisitor(BooleanClause.Occur occur) {
        final List children = this.childVisitors.computeIfAbsent(occur, k -> new ArrayList());
        CheckedQueryBuilderVisitor childVisitorWrapper = new CheckedQueryBuilderVisitor<V, R, E>(){
            V currentChild;

            @Override
            public R accept(QueryBuilder qb) throws Exception {
                this.currentChild = CheckedQueryShapeVisitor.this.newInstance();
                children.add(this.currentChild);
                return this.currentChild.accept(qb);
            }

            @Override
            public V getChildVisitor(BooleanClause.Occur occur) {
                return this.currentChild.getChildVisitor(occur);
            }
        };
        children.add(childVisitorWrapper);
        return (V)childVisitorWrapper;
    }

    public abstract R visit(QueryBuilder var1) throws E;

    protected abstract V newInstance();
}

