/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.OpenSearchVersion;
import io.skylite.core.ParseField;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.Strings;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.logging.DeprecationLogger;
import io.skylite.core.index.query.AbstractQueryBuilder;
import io.skylite.core.index.query.MatchNoneQueryBuilder;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardContext;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.xcontent.ObjectParser;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.search.Query;

public class IdsQueryBuilder
extends AbstractQueryBuilder<IdsQueryBuilder> {
    public static final String NAME = "ids";
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(IdsQueryBuilder.class);
    static final String TYPES_DEPRECATION_MESSAGE = "[types removal] Types are deprecated in [ids] queries.";
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField VALUES_FIELD = new ParseField("values", new String[0]);
    private final Set<String> ids = new HashSet<String>();
    private static final ObjectParser<IdsQueryBuilder, Void> PARSER = new ObjectParser("ids", IdsQueryBuilder::new);

    public IdsQueryBuilder() {
    }

    public IdsQueryBuilder(StreamInput in) throws IOException {
        super(in);
        Object[] types;
        if (in.getVersion().before(OpenSearchVersion.V_2_0_0) && (types = in.readStringArray()).length > 0) {
            throw new IllegalStateException("types are no longer supported in ids query but found [" + Arrays.toString(types) + "]");
        }
        Collections.addAll(this.ids, in.readStringArray());
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        if (out.getVersion().before(OpenSearchVersion.V_2_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeStringArray(this.ids.toArray(new String[0]));
    }

    public IdsQueryBuilder addIds(String ... ids) {
        if (ids == null) {
            throw new IllegalArgumentException("[ids] ids cannot be null");
        }
        Collections.addAll(this.ids, ids);
        return this;
    }

    public Set<String> ids() {
        return this.ids;
    }

    @Override
    protected void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(NAME);
        builder.startArray(VALUES_FIELD.getPreferredName());
        for (String value : this.ids) {
            builder.value(value);
        }
        builder.endArray();
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }

    public static IdsQueryBuilder fromXContent(XContentParser parser) {
        try {
            return PARSER.apply(parser, null);
        }
        catch (IllegalArgumentException e) {
            throw new ParsingException(parser.getTokenLocation(), e.getMessage(), e, new Object[0]);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    protected QueryBuilder doRewrite(QueryRewriteContext queryRewriteContext) throws IOException {
        if (this.ids.isEmpty()) {
            return new MatchNoneQueryBuilder();
        }
        QueryShardContext context = QueryShardContext.convertFromQueryRewriteContext(queryRewriteContext);
        if (context != null && context.getFieldType(ParseField.CommonMetaFields.ID_FIELD.getPreferredName()) == null) {
            return new MatchNoneQueryBuilder();
        }
        return super.doRewrite(queryRewriteContext);
    }

    @Override
    protected Query doToQuery(QueryShardContext context) throws IOException {
        MappedFieldType idField = context.getFieldType(ParseField.CommonMetaFields.ID_FIELD.getPreferredName());
        if (idField == null || this.ids.isEmpty()) {
            throw new IllegalStateException("Rewrite first");
        }
        return idField.termsQuery(new ArrayList<String>(this.ids), context);
    }

    @Override
    protected int doHashCode() {
        return Objects.hash(this.ids);
    }

    @Override
    protected boolean doEquals(IdsQueryBuilder other) {
        return Objects.equals(this.ids, other.ids);
    }

    static {
        PARSER.declareStringArray(ObjectParser.fromList(String.class, IdsQueryBuilder::addIds), VALUES_FIELD);
        IdsQueryBuilder.declareStandardFields(PARSER);
    }
}

