/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.common.action.ActionListener;
import io.skylite.common.util.concurrent.CountDown;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.xcontent.NamedXContentRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.LongSupplier;
import org.apache.lucene.search.Query;

public class QueryRewriteContext {
    protected final Map<String, Query> namedQueries = new HashMap<String, Query>();
    private final NamedXContentRegistry xContentRegistry;
    private final NamedWriteableRegistry writeableRegistry;
    protected final SkyliteClient client;
    protected final LongSupplier nowInMillis;
    private final List<BiConsumer<SkyliteClient, ActionListener<?>>> asyncActions = new ArrayList();
    private final boolean validate;

    public QueryRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, SkyliteClient client, LongSupplier nowInMillis) {
        this(xContentRegistry, writeableRegistry, client, nowInMillis, false);
    }

    public QueryRewriteContext(NamedXContentRegistry xContentRegistry, NamedWriteableRegistry writeableRegistry, SkyliteClient client, LongSupplier nowInMillis, boolean validate) {
        this.xContentRegistry = xContentRegistry;
        this.writeableRegistry = writeableRegistry;
        this.client = client;
        this.nowInMillis = nowInMillis;
        this.validate = validate;
    }

    public NamedXContentRegistry getXContentRegistry() {
        return this.xContentRegistry;
    }

    public long nowInMillis() {
        return this.nowInMillis.getAsLong();
    }

    public NamedWriteableRegistry getWriteableRegistry() {
        return this.writeableRegistry;
    }

    public void addNamedQuery(String name, Query query) {
        if (query != null) {
            this.namedQueries.put(name, query);
        }
    }

    public Map<String, Query> copyNamedQueries() {
        return Map.copyOf(this.namedQueries);
    }

    public void registerAsyncAction(BiConsumer<SkyliteClient, ActionListener<?>> asyncAction) {
        this.asyncActions.add(asyncAction);
    }

    public boolean hasAsyncActions() {
        return !this.asyncActions.isEmpty();
    }

    public void executeAsyncActions(final ActionListener listener) {
        if (this.asyncActions.isEmpty()) {
            listener.onResponse(null);
        } else {
            final CountDown countDown = new CountDown(this.asyncActions.size());
            ActionListener internalListener = new ActionListener(){

                public void onResponse(Object o) {
                    if (countDown.countDown()) {
                        listener.onResponse(null);
                    }
                }

                public void onFailure(Exception e) {
                    if (countDown.fastForward()) {
                        listener.onFailure(e);
                    }
                }
            };
            ArrayList biConsumers = new ArrayList(this.asyncActions);
            this.asyncActions.clear();
            for (BiConsumer biConsumer : biConsumers) {
                biConsumer.accept(this.client, internalListener);
            }
        }
    }

    public boolean validate() {
        return this.validate;
    }
}

