/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.common.SetOnce;
import io.skylite.common.TriFunction;
import io.skylite.common.action.ActionListener;
import io.skylite.core.aggregations.AggregationRegistry;
import io.skylite.core.analysis.NamedAnalyzer;
import io.skylite.core.client.SkyliteClient;
import io.skylite.core.common.ParsingException;
import io.skylite.core.common.io.stream.NamedWriteableRegistry;
import io.skylite.core.common.regex.Regex;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.IndexSortConfig;
import io.skylite.core.index.analysis.IndexAnalyzers;
import io.skylite.core.index.cache.bitset.BitsetFilterCache;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.query.NestedScope;
import io.skylite.core.index.query.ParsedQuery;
import io.skylite.core.index.query.QueryBuilder;
import io.skylite.core.index.query.QueryRewriteContext;
import io.skylite.core.index.query.QueryShardException;
import io.skylite.core.index.query.Rewriteable;
import io.skylite.core.index.similarity.SimilarityService;
import io.skylite.core.lucene.search.Queries;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.ContentPath;
import io.skylite.core.mapper.FieldMapper;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.Mapper;
import io.skylite.core.mapper.MapperParsingException;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.mapper.MappingLookup;
import io.skylite.core.mapper.MappingParserContext;
import io.skylite.core.mapper.ObjectMapper;
import io.skylite.core.mapper.ParsedDocument;
import io.skylite.core.mapper.RuntimeFieldType;
import io.skylite.core.mapper.SourceToParse;
import io.skylite.core.mapper.TextFieldMapper;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptContext;
import io.skylite.core.script.ScriptFactory;
import io.skylite.core.script.ScriptService;
import io.skylite.core.search.lookup.SearchLookup;
import io.skylite.core.transport.RemoteClusterUtils;
import io.skylite.core.xcontent.NamedXContentRegistry;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.search.similarities.Similarity;

public class QueryShardContext
extends QueryRewriteContext {
    private final ScriptService scriptService;
    private final IndexSettings indexSettings;
    private final BigArrays bigArrays;
    private final MapperService mapperService;
    private final MappingLookup mappingLookup;
    private final SimilarityService similarityService;
    private final BitsetFilterCache bitsetFilterCache;
    private final TriFunction<BaseMappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataService;
    private SearchLookup lookup = null;
    private final int shardId;
    private final IndexSearcher searcher;
    private boolean cacheable = true;
    private final SetOnce<Boolean> frozen = new SetOnce();
    private final Index fullyQualifiedIndex;
    private final Predicate<String> indexNameMatcher;
    private final BooleanSupplier allowExpensiveQueries;
    private boolean allowUnmappedFields;
    private boolean mapUnmappedFieldAsString;
    private NestedScope nestedScope;
    private final AggregationRegistry aggregationRegistry;
    private final Map<String, MappedFieldType> runtimeMappings;
    private BitSetProducer parentFilter;

    public QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<BaseMappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, SkyliteClient client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, AggregationRegistry aggregationRegistry) {
        this(shardId, indexSettings, bigArrays, bitsetFilterCache, indexFieldDataLookup, mapperService, mappingLookup, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, clusterAlias, indexNameMatcher, allowExpensiveQueries, aggregationRegistry, Collections.emptyMap(), false);
    }

    public QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<BaseMappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, SkyliteClient client, IndexSearcher searcher, LongSupplier nowInMillis, String clusterAlias, Predicate<String> indexNameMatcher, BooleanSupplier allowExpensiveQueries, AggregationRegistry aggregationRegistry, Map<String, Object> runtimeMappings, boolean validate) {
        this(shardId, indexSettings, bigArrays, bitsetFilterCache, indexFieldDataLookup, mapperService, mappingLookup, similarityService, scriptService, xContentRegistry, namedWriteableRegistry, client, searcher, nowInMillis, indexNameMatcher, new Index(RemoteClusterUtils.buildRemoteIndexName(clusterAlias, indexSettings.getIndex().getName()), indexSettings.getIndex().getUUID()), allowExpensiveQueries, aggregationRegistry, QueryShardContext.parseRuntimeMappings(runtimeMappings, mapperService), validate);
    }

    public QueryShardContext(QueryShardContext source) {
        this(source.shardId, source.indexSettings, source.bigArrays, source.bitsetFilterCache, source.indexFieldDataService, source.mapperService, source.mappingLookup, source.similarityService, source.scriptService, source.getXContentRegistry(), source.getWriteableRegistry(), source.client, source.searcher, source.nowInMillis, source.indexNameMatcher, source.fullyQualifiedIndex, source.allowExpensiveQueries, source.aggregationRegistry, source.runtimeMappings, source.validate());
    }

    private QueryShardContext(int shardId, IndexSettings indexSettings, BigArrays bigArrays, BitsetFilterCache bitsetFilterCache, TriFunction<BaseMappedFieldType, String, Supplier<SearchLookup>, IndexFieldData<?>> indexFieldDataLookup, MapperService mapperService, MappingLookup mappingLookup, SimilarityService similarityService, ScriptService scriptService, NamedXContentRegistry xContentRegistry, NamedWriteableRegistry namedWriteableRegistry, SkyliteClient client, IndexSearcher searcher, LongSupplier nowInMillis, Predicate<String> indexNameMatcher, Index fullyQualifiedIndex, BooleanSupplier allowExpensiveQueries, AggregationRegistry aggregationRegistry, Map<String, MappedFieldType> runtimeMappings, boolean validate) {
        super(xContentRegistry, namedWriteableRegistry, client, nowInMillis, validate);
        this.shardId = shardId;
        this.similarityService = similarityService;
        this.mapperService = mapperService;
        this.mappingLookup = mappingLookup;
        this.bigArrays = bigArrays;
        this.bitsetFilterCache = bitsetFilterCache;
        this.indexFieldDataService = indexFieldDataLookup;
        this.allowUnmappedFields = indexSettings.isDefaultAllowUnmappedFields();
        this.nestedScope = new NestedScope();
        this.scriptService = scriptService;
        this.indexSettings = indexSettings;
        this.searcher = searcher;
        this.indexNameMatcher = indexNameMatcher;
        this.fullyQualifiedIndex = fullyQualifiedIndex;
        this.allowExpensiveQueries = allowExpensiveQueries;
        this.aggregationRegistry = aggregationRegistry;
        this.runtimeMappings = runtimeMappings;
    }

    private void reset() {
        this.allowUnmappedFields = this.indexSettings.isDefaultAllowUnmappedFields();
        this.lookup = null;
        this.namedQueries.clear();
        this.nestedScope = new NestedScope();
    }

    public Analyzer getIndexAnalyzer(final Function<String, NamedAnalyzer> unindexedFieldAnalyzer) {
        return new DelegatingAnalyzerWrapper(Analyzer.PER_FIELD_REUSE_STRATEGY){

            protected Analyzer getWrappedAnalyzer(String fieldName) {
                return QueryShardContext.this.mappingLookup.indexAnalyzer(fieldName, unindexedFieldAnalyzer);
            }
        };
    }

    public IndexAnalyzers getIndexAnalyzers() {
        return this.mapperService.getIndexAnalyzers();
    }

    public Similarity getSearchSimilarity() {
        return this.similarityService != null ? this.similarityService.similarity(this::getFieldType) : null;
    }

    public List<String> defaultFields() {
        return this.indexSettings.getDefaultFields();
    }

    public boolean queryStringLenient() {
        return this.indexSettings.isQueryStringLenient();
    }

    public boolean queryStringAnalyzeWildcard() {
        return this.indexSettings.isQueryStringAnalyzeWildcard();
    }

    public boolean queryStringAllowLeadingWildcard() {
        return this.indexSettings.isQueryStringAllowLeadingWildcard();
    }

    public BitSetProducer bitsetFilter(Query filter) {
        return this.bitsetFilterCache.getBitSetProducer(filter);
    }

    public boolean allowExpensiveQueries() {
        return this.allowExpensiveQueries.getAsBoolean();
    }

    public <IFD extends IndexFieldData<?>> IFD getForField(MappedFieldType fieldType) {
        return (IFD)((IndexFieldData)this.indexFieldDataService.apply((Object)fieldType, (Object)this.fullyQualifiedIndex.getName(), () -> this.lookup().forkAndTrackFieldReferences(fieldType.name())));
    }

    public ParsedDocument parseDocument(SourceToParse source) throws MapperParsingException {
        return this.mapperService.documentParser().parseDocument(source, this.mappingLookup);
    }

    public boolean hasNested() {
        return this.mappingLookup.hasNested();
    }

    public Set<String> simpleMatchToIndexNames(String pattern) {
        if (this.runtimeMappings.isEmpty()) {
            return this.mappingLookup.simpleMatchToFullName(pattern);
        }
        if (!Regex.isSimpleMatchPattern(pattern)) {
            return Collections.singleton(pattern);
        }
        HashSet<String> matches = new HashSet<String>(this.mappingLookup.simpleMatchToFullName(pattern));
        for (String name : this.runtimeMappings.keySet()) {
            if (!Regex.simpleMatch(pattern, name)) continue;
            matches.add(name);
        }
        return matches;
    }

    public boolean hasMappings() {
        return this.mappingLookup.hasMappings();
    }

    public MappedFieldType getFieldType(String name) {
        return this.failIfFieldMappingNotFound(name, this.fieldType(name));
    }

    public boolean isFieldMapped(String name) {
        return this.fieldType(name) != null;
    }

    private MappedFieldType fieldType(String name) {
        MappedFieldType fieldType = this.runtimeMappings.get(name);
        return fieldType == null ? this.mappingLookup.getFieldType(name) : fieldType;
    }

    public ObjectMapper getObjectMapper(String name) {
        return this.mappingLookup.objectMappers().get(name);
    }

    public boolean isMetadataField(String field) {
        return this.mapperService.isMetadataField(field);
    }

    public Set<String> sourcePath(String fullName) {
        return this.mappingLookup.sourcePaths(fullName);
    }

    public boolean isSourceEnabled() {
        return this.mappingLookup.isSourceEnabled();
    }

    public MappedFieldType buildAnonymousFieldType(String type) {
        MappingParserContext parserContext = this.mapperService.parserContext();
        Mapper.TypeParser typeParser = parserContext.typeParser(type);
        if (typeParser == null) {
            throw new IllegalArgumentException("No mapper found for type [" + type + "]");
        }
        Mapper.Builder builder = typeParser.parse("__anonymous_", Collections.emptyMap(), parserContext);
        Mapper mapper = builder.build(new ContentPath(1));
        if (mapper instanceof FieldMapper) {
            return ((FieldMapper)mapper).fieldType();
        }
        throw new IllegalArgumentException("Mapper for type [" + type + "] must be a leaf field");
    }

    public AggregationRegistry getAggregationRegistry() {
        return this.aggregationRegistry;
    }

    public void setAllowUnmappedFields(boolean allowUnmappedFields) {
        this.allowUnmappedFields = allowUnmappedFields;
    }

    public void setMapUnmappedFieldAsString(boolean mapUnmappedFieldAsString) {
        this.mapUnmappedFieldAsString = mapUnmappedFieldAsString;
    }

    MappedFieldType failIfFieldMappingNotFound(String name, MappedFieldType fieldMapping) {
        if (fieldMapping != null || this.allowUnmappedFields) {
            return fieldMapping;
        }
        if (this.mapUnmappedFieldAsString) {
            TextFieldMapper.Builder builder = new TextFieldMapper.Builder(name, this.getIndexAnalyzers());
            return builder.build(new ContentPath(1)).fieldType();
        }
        throw new QueryShardException(this.getFullyQualifiedIndex(), "No field mapping can be found for the field with name [{}]", name);
    }

    public boolean containsBrokenAnalysis(String field) {
        NamedAnalyzer a = this.mappingLookup.indexAnalyzer(field, f -> null);
        return a == null ? false : a.containsBrokenAnalysis();
    }

    public SearchLookup lookup() {
        if (this.lookup == null) {
            this.lookup = new SearchLookup(this::getFieldType, (fieldType, searchLookup) -> (BaseIndexFieldData)this.indexFieldDataService.apply(fieldType, (Object)this.fullyQualifiedIndex.getName(), searchLookup));
        }
        return this.lookup;
    }

    public SearchLookup newFetchLookup() {
        return new SearchLookup(this::getFieldType, (fieldType, searchLookup) -> (BaseIndexFieldData)this.indexFieldDataService.apply(fieldType, (Object)this.fullyQualifiedIndex.getName(), searchLookup));
    }

    public NestedScope nestedScope() {
        return this.nestedScope;
    }

    public Version indexVersionCreated() {
        return this.indexSettings.getIndexVersionCreated();
    }

    public boolean indexMatches(String pattern) {
        return this.indexNameMatcher.test(pattern);
    }

    public boolean indexSortedOnField(String field) {
        IndexSortConfig indexSortConfig = this.indexSettings.getIndexSortConfig();
        return indexSortConfig.hasPrimarySortOnField(field);
    }

    public ParsedQuery toQuery(QueryBuilder queryBuilder) {
        return this.toQuery(queryBuilder, (CheckedFunction<QueryBuilder, Query, IOException>)((CheckedFunction)q -> {
            Query query = q.toQuery(this);
            if (query == null) {
                query = Queries.newMatchNoDocsQuery("No query left after rewrite.");
            }
            return query;
        }));
    }

    private ParsedQuery toQuery(QueryBuilder queryBuilder, CheckedFunction<QueryBuilder, Query, IOException> filterOrQuery) {
        this.reset();
        try {
            QueryBuilder rewriteQuery = Rewriteable.rewrite(queryBuilder, this, true);
            ParsedQuery parsedQuery = new ParsedQuery((Query)filterOrQuery.apply((Object)rewriteQuery), this.copyNamedQueries());
            return parsedQuery;
        }
        catch (ParsingException | QueryShardException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueryShardException(this.fullyQualifiedIndex, "failed to create query: {}", e, e.getMessage());
        }
        finally {
            this.reset();
        }
    }

    public Index index() {
        return this.indexSettings.getIndex();
    }

    public <FactoryType> FactoryType compile(Script script, ScriptContext<FactoryType> context) {
        FactoryType factory = this.scriptService.compile(script, context);
        if (factory instanceof ScriptFactory && !((ScriptFactory)factory).isResultDeterministic()) {
            this.failIfFrozen();
        }
        return factory;
    }

    public final void freezeContext() {
        this.frozen.set((Object)Boolean.TRUE);
    }

    protected final void failIfFrozen() {
        this.cacheable = false;
        if (this.frozen.get() == Boolean.TRUE) {
            throw new IllegalArgumentException("features that prevent cachability are disabled on this context");
        }
        assert (this.frozen.get() == null) : (Boolean)this.frozen.get();
    }

    @Override
    public void registerAsyncAction(BiConsumer<SkyliteClient, ActionListener<?>> asyncAction) {
        this.failIfFrozen();
        super.registerAsyncAction(asyncAction);
    }

    @Override
    public void executeAsyncActions(ActionListener listener) {
        this.failIfFrozen();
        super.executeAsyncActions(listener);
    }

    public final boolean isCacheable() {
        return this.cacheable;
    }

    public int getShardId() {
        return this.shardId;
    }

    @Override
    public final long nowInMillis() {
        this.failIfFrozen();
        return super.nowInMillis();
    }

    public SkyliteClient getClient() {
        this.failIfFrozen();
        return this.client;
    }

    public QueryBuilder parseInnerQueryBuilder(XContentParser parser) throws IOException {
        return QueryBuilder.parseInnerQueryBuilder(parser);
    }

    public IndexSettings getIndexSettings() {
        return this.indexSettings;
    }

    public IndexReader getIndexReader() {
        return this.searcher == null ? null : this.searcher.getIndexReader();
    }

    public IndexSearcher searcher() {
        return this.searcher;
    }

    public Index getFullyQualifiedIndex() {
        return this.fullyQualifiedIndex;
    }

    public BigArrays bigArrays() {
        return this.bigArrays;
    }

    public SimilarityService getSimilarityService() {
        return this.similarityService;
    }

    public BitsetFilterCache getBitsetFilterCache() {
        return this.bitsetFilterCache;
    }

    public BitSetProducer getParentFilter() {
        return this.parentFilter;
    }

    public void setParentFilter(BitSetProducer parentFilter) {
        this.parentFilter = parentFilter;
    }

    public static QueryShardContext convertFromQueryRewriteContext(QueryRewriteContext queryRewriteContext) {
        if (queryRewriteContext instanceof QueryShardContext) {
            return (QueryShardContext)QueryShardContext.class.cast(queryRewriteContext);
        }
        return null;
    }

    public MappingLookup.CacheKey mappingCacheKey() {
        return this.mappingLookup.cacheKey();
    }

    private static Map<String, MappedFieldType> parseRuntimeMappings(Map<String, Object> runtimeMappings, MapperService mapperService) {
        HashMap runtimeFieldTypes = new HashMap();
        if (!runtimeMappings.isEmpty()) {
            RuntimeFieldType.parseRuntimeFields(new HashMap<String, Object>(runtimeMappings), mapperService.parserContext(), runtimeFieldType -> runtimeFieldTypes.put(runtimeFieldType.name(), runtimeFieldType));
        }
        return Collections.unmodifiableMap(runtimeFieldTypes);
    }
}

