/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.query;

import io.skylite.core.action.support.IndicesOptions;
import io.skylite.core.cluster.metadata.IndexNameExpressionResolver;
import io.skylite.core.cluster.service.ClusterService;
import io.skylite.core.common.regex.Regex;
import java.util.function.Predicate;

public class SearchIndexNameMatcher
implements Predicate<String> {
    private final String indexName;
    private final String clusterAlias;
    private final ClusterService clusterService;
    private final IndexNameExpressionResolver expressionResolver;

    public SearchIndexNameMatcher(String indexName, String clusterAlias, ClusterService clusterService, IndexNameExpressionResolver expressionResolver) {
        this.indexName = indexName;
        this.clusterAlias = "".equals(clusterAlias) ? null : clusterAlias;
        this.clusterService = clusterService;
        this.expressionResolver = expressionResolver;
    }

    @Override
    public boolean test(String pattern) {
        int separatorIndex = pattern.indexOf(58);
        if (separatorIndex < 0) {
            return this.clusterAlias == null && this.matchesIndex(pattern);
        }
        String clusterPattern = pattern.substring(0, separatorIndex);
        String indexPattern = pattern.substring(separatorIndex + 1);
        return Regex.simpleMatch(clusterPattern, this.clusterAlias) && this.matchesIndex(indexPattern);
    }

    private boolean matchesIndex(String pattern) {
        String[] concreteIndices;
        for (String index : concreteIndices = this.expressionResolver.concreteIndexNames(this.clusterService.state(), IndicesOptions.lenientExpandOpen(), true, pattern)) {
            if (!Regex.simpleMatch(index, this.indexName)) continue;
            return true;
        }
        return false;
    }
}

