/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote;

import io.skylite.OpenSearchVersion;
import io.skylite.Version;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.remote.RemoteStoreSettings;
import io.skylite.core.node.RemoteStoreNodeAttribute;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.settings.Settings;
import java.util.function.Supplier;

public class RemoteStoreCustomMetadataResolver {
    private final RemoteStoreSettings remoteStoreSettings;
    private final Supplier<Version<?>> minNodeVersionSupplier;
    private final Supplier<RepositoriesService> repositoriesServiceSupplier;
    private final Settings settings;

    public RemoteStoreCustomMetadataResolver(RemoteStoreSettings remoteStoreSettings, Supplier<Version<?>> minNodeVersionSupplier, Supplier<RepositoriesService> repositoriesServiceSupplier, Settings settings) {
        this.remoteStoreSettings = remoteStoreSettings;
        this.minNodeVersionSupplier = minNodeVersionSupplier;
        this.repositoriesServiceSupplier = repositoriesServiceSupplier;
        this.settings = settings;
    }

    public RemoteStorePathStrategy getPathStrategy() {
        RemoteStoreEnums.PathType pathType = OpenSearchVersion.V_2_14_0.compareTo(this.minNodeVersionSupplier.get()) <= 0 ? this.remoteStoreSettings.getPathType() : RemoteStoreEnums.PathType.FIXED;
        RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm = pathType == RemoteStoreEnums.PathType.FIXED ? null : this.remoteStoreSettings.getPathHashAlgorithm();
        return new RemoteStorePathStrategy(pathType, pathHashAlgorithm);
    }

    public boolean isTranslogMetadataEnabled() {
        Repository repository;
        try {
            repository = this.repositoriesServiceSupplier.get().repository(RemoteStoreNodeAttribute.getRemoteStoreTranslogRepo(this.settings));
        }
        catch (RepositoryMissingException ex) {
            throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", ex);
        }
        BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
        return OpenSearchVersion.fromId(2150099).compareTo(this.minNodeVersionSupplier.get()) <= 0 && this.remoteStoreSettings.isTranslogMetadataEnabled() && blobStoreRepository.blobStore().isBlobMetadataEnabled();
    }
}

