/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote;

import io.skylite.common.Nullable;
import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.index.remote.RemoteStoreEnums;
import java.util.Objects;
import org.apache.logging.log4j.message.ParameterizedMessage;

public class RemoteStorePathStrategy {
    private final RemoteStoreEnums.PathType type;
    @Nullable
    private final RemoteStoreEnums.PathHashAlgorithm hashAlgorithm;

    public RemoteStorePathStrategy(RemoteStoreEnums.PathType type) {
        this(type, null);
    }

    public RemoteStorePathStrategy(RemoteStoreEnums.PathType type, RemoteStoreEnums.PathHashAlgorithm hashAlgorithm) {
        Objects.requireNonNull(type, "pathType can not be null");
        if (!RemoteStorePathStrategy.isCompatible(type, hashAlgorithm)) {
            throw new IllegalArgumentException(new ParameterizedMessage("pathType={} pathHashAlgorithm={} are incompatible", (Object)type, (Object)hashAlgorithm).getFormattedMessage());
        }
        this.type = type;
        this.hashAlgorithm = hashAlgorithm;
    }

    public static boolean isCompatible(RemoteStoreEnums.PathType type, RemoteStoreEnums.PathHashAlgorithm hashAlgorithm) {
        return !type.requiresHashAlgorithm() && Objects.isNull((Object)hashAlgorithm) || type.requiresHashAlgorithm() && Objects.nonNull((Object)hashAlgorithm);
    }

    public RemoteStoreEnums.PathType getType() {
        return this.type;
    }

    public RemoteStoreEnums.PathHashAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public String toString() {
        return "RemoteStorePathStrategy{type=" + String.valueOf((Object)this.type) + ", hashAlgorithm=" + String.valueOf((Object)this.hashAlgorithm) + "}";
    }

    public BlobPath generatePath(PathInput pathInput) {
        return this.type.path(pathInput, this.hashAlgorithm);
    }

    public static class PathInput {
        private final BlobPath basePath;
        private final String indexUUID;
        private final String shardId;
        private final RemoteStoreEnums.DataCategory dataCategory;
        private final RemoteStoreEnums.DataType dataType;

        public PathInput(BlobPath basePath, String indexUUID, String shardId, RemoteStoreEnums.DataCategory dataCategory, RemoteStoreEnums.DataType dataType) {
            this.basePath = Objects.requireNonNull(basePath);
            this.indexUUID = Objects.requireNonNull(indexUUID);
            this.shardId = Objects.requireNonNull(shardId);
            this.dataCategory = Objects.requireNonNull(dataCategory);
            this.dataType = Objects.requireNonNull(dataType);
        }

        BlobPath basePath() {
            return this.basePath;
        }

        String indexUUID() {
            return this.indexUUID;
        }

        String shardId() {
            return this.shardId;
        }

        RemoteStoreEnums.DataCategory dataCategory() {
            return this.dataCategory;
        }

        RemoteStoreEnums.DataType dataType() {
            return this.dataType;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder {
            private BlobPath basePath;
            private String indexUUID;
            private String shardId;
            private RemoteStoreEnums.DataCategory dataCategory;
            private RemoteStoreEnums.DataType dataType;

            public Builder basePath(BlobPath basePath) {
                this.basePath = basePath;
                return this;
            }

            public Builder indexUUID(String indexUUID) {
                this.indexUUID = indexUUID;
                return this;
            }

            public Builder shardId(String shardId) {
                this.shardId = shardId;
                return this;
            }

            public Builder dataCategory(RemoteStoreEnums.DataCategory dataCategory) {
                this.dataCategory = dataCategory;
                return this;
            }

            public Builder dataType(RemoteStoreEnums.DataType dataType) {
                this.dataType = dataType;
                return this;
            }

            public PathInput build() {
                return new PathInput(this.basePath, this.indexUUID, this.shardId, this.dataCategory, this.dataType);
            }
        }
    }
}

