/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote;

import io.skylite.LegacyESVersion;
import io.skylite.Version;
import io.skylite.common.annotation.ExperimentalApi;
import io.skylite.common.annotation.PublicApi;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.indices.replication.common.ReplicationType;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class RemoteStoreSettings {
    @PublicApi(since="2.7.0")
    public static final Setting<Boolean> INDEX_REMOTE_STORE_ENABLED_SETTING = Setting.boolSetting("index.remote_store.enabled", false, new Setting.Validator<Boolean>(){

        @Override
        public void validate(Boolean value) {
        }

        @Override
        public void validate(Boolean value, Map<Setting<?>, Object> settings) {
            Object replicationType = settings.get(ReplicationType.INDEX_REPLICATION_TYPE_SETTING);
            if (!ReplicationType.SEGMENT.equals(replicationType) && value.booleanValue()) {
                throw new IllegalArgumentException("To enable " + INDEX_REMOTE_STORE_ENABLED_SETTING.getKey() + ", " + ReplicationType.INDEX_REPLICATION_TYPE_SETTING.getKey() + " should be set to " + String.valueOf((Object)ReplicationType.SEGMENT));
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<ReplicationType>> settings = List.of(ReplicationType.INDEX_REPLICATION_TYPE_SETTING);
            return settings.iterator();
        }
    }, Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.Dynamic);
    public static final Setting<TimeValue> CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING = Setting.timeSetting("cluster.remote_store.translog.buffer_interval", IndexSettings.DEFAULT_REMOTE_TRANSLOG_BUFFER_INTERVAL, IndexSettings.MINIMUM_REMOTE_TRANSLOG_BUFFER_INTERVAL, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING = Setting.intSetting("cluster.remote_store.index.segment_metadata.retention.max_count", 10, -1, v -> {
        if (v == 0) {
            throw new IllegalArgumentException("Value 0 is not allowed for this setting as it would delete all the data from remote segment store");
        }
    }, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.segment.transfer_timeout", TimeValue.timeValueMinutes((long)30L), TimeValue.timeValueMinutes((long)10L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<RemoteStoreEnums.PathType> CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING = new Setting<RemoteStoreEnums.PathType>("cluster.remote_store.index.path.type", RemoteStoreEnums.PathType.FIXED.toString(), RemoteStoreEnums.PathType::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    @ExperimentalApi
    public static final Setting<Boolean> CLUSTER_REMOTE_STORE_TRANSLOG_METADATA = Setting.boolSetting("cluster.remote_store.index.translog.translog_metadata", true, Setting.Property.NodeScope, Setting.Property.Dynamic);
    @ExperimentalApi
    public static final Setting<RemoteStoreEnums.PathHashAlgorithm> CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING = new Setting<RemoteStoreEnums.PathHashAlgorithm>("cluster.remote_store.index.path.hash_algorithm", RemoteStoreEnums.PathHashAlgorithm.FNV_1A_COMPOSITE_1.toString(), RemoteStoreEnums.PathHashAlgorithm::parseString, Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Integer> CLUSTER_REMOTE_MAX_TRANSLOG_READERS = Setting.intSetting("cluster.remote_store.translog.max_readers", 1000, 100, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING = Setting.timeSetting("cluster.remote_store.translog.transfer_timeout", TimeValue.timeValueSeconds((long)30L), TimeValue.timeValueSeconds((long)30L), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Version SEARCHABLE_SNAPSHOT_EXTENDED_COMPATIBILITY_MINIMUM_VERSION = LegacyESVersion.V_6_0_0;
    public static final String LOCAL_STORE_LOCATION = "RemoteLocalStore";
    private volatile TimeValue clusterRemoteTranslogBufferInterval;
    private volatile int minRemoteSegmentMetadataFiles;
    private volatile TimeValue clusterRemoteTranslogTransferTimeout;
    private volatile TimeValue clusterRemoteSegmentTransferTimeout;
    private volatile RemoteStoreEnums.PathType pathType;
    private volatile RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm;
    private volatile int maxRemoteTranslogReaders;
    private volatile boolean isTranslogMetadataEnabled;

    public RemoteStoreSettings(Settings settings, ClusterSettings clusterSettings) {
        this.clusterRemoteTranslogBufferInterval = CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING, this::setClusterRemoteTranslogBufferInterval);
        this.minRemoteSegmentMetadataFiles = CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING, this::setMinRemoteSegmentMetadataFiles);
        this.clusterRemoteSegmentTransferTimeout = CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING, this::setClusterRemoteSegmentTransferTimeout);
        this.pathType = clusterSettings.get(CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING, this::setPathType);
        this.isTranslogMetadataEnabled = clusterSettings.get(CLUSTER_REMOTE_STORE_TRANSLOG_METADATA);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_TRANSLOG_METADATA, this::setTranslogMetadataEnabled);
        this.pathHashAlgorithm = clusterSettings.get(CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING, this::setPathHashAlgorithm);
        this.maxRemoteTranslogReaders = CLUSTER_REMOTE_MAX_TRANSLOG_READERS.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_MAX_TRANSLOG_READERS, this::setMaxRemoteTranslogReaders);
        this.clusterRemoteTranslogTransferTimeout = CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING.get(settings);
        clusterSettings.addSettingsUpdateConsumer(CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING, this::setClusterRemoteTranslogTransferTimeout);
    }

    public TimeValue getClusterRemoteSegmentTransferTimeout() {
        return this.clusterRemoteSegmentTransferTimeout;
    }

    private void setClusterRemoteSegmentTransferTimeout(TimeValue clusterRemoteSegmentTransferTimeout) {
        this.clusterRemoteSegmentTransferTimeout = clusterRemoteSegmentTransferTimeout;
    }

    public int getMinRemoteSegmentMetadataFiles() {
        return this.minRemoteSegmentMetadataFiles;
    }

    private void setMinRemoteSegmentMetadataFiles(int minRemoteSegmentMetadataFiles) {
        this.minRemoteSegmentMetadataFiles = minRemoteSegmentMetadataFiles;
    }

    public TimeValue getClusterRemoteTranslogBufferInterval() {
        return this.clusterRemoteTranslogBufferInterval;
    }

    private void setClusterRemoteTranslogBufferInterval(TimeValue clusterRemoteTranslogBufferInterval) {
        this.clusterRemoteTranslogBufferInterval = clusterRemoteTranslogBufferInterval;
    }

    public TimeValue getClusterRemoteTranslogTransferTimeout() {
        return this.clusterRemoteTranslogTransferTimeout;
    }

    private void setClusterRemoteTranslogTransferTimeout(TimeValue clusterRemoteTranslogTransferTimeout) {
        this.clusterRemoteTranslogTransferTimeout = clusterRemoteTranslogTransferTimeout;
    }

    @ExperimentalApi
    public RemoteStoreEnums.PathType getPathType() {
        return this.pathType;
    }

    @ExperimentalApi
    public RemoteStoreEnums.PathHashAlgorithm getPathHashAlgorithm() {
        return this.pathHashAlgorithm;
    }

    private void setPathType(RemoteStoreEnums.PathType pathType) {
        this.pathType = pathType;
    }

    private void setTranslogMetadataEnabled(boolean isTranslogMetadataEnabled) {
        this.isTranslogMetadataEnabled = isTranslogMetadataEnabled;
    }

    public boolean isTranslogMetadataEnabled() {
        return this.isTranslogMetadataEnabled;
    }

    private void setPathHashAlgorithm(RemoteStoreEnums.PathHashAlgorithm pathHashAlgorithm) {
        this.pathHashAlgorithm = pathHashAlgorithm;
    }

    public int getMaxRemoteTranslogReaders() {
        return this.maxRemoteTranslogReaders;
    }

    private void setMaxRemoteTranslogReaders(int maxRemoteTranslogReaders) {
        this.maxRemoteTranslogReaders = maxRemoteTranslogReaders;
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDEX_REMOTE_STORE_ENABLED_SETTING, CLUSTER_REMOTE_SEGMENT_TRANSFER_TIMEOUT_SETTING, CLUSTER_REMOTE_TRANSLOG_BUFFER_INTERVAL_SETTING, CLUSTER_REMOTE_INDEX_SEGMENT_METADATA_RETENTION_MAX_COUNT_SETTING, CLUSTER_REMOTE_TRANSLOG_TRANSFER_TIMEOUT_SETTING, CLUSTER_REMOTE_STORE_PATH_TYPE_SETTING, CLUSTER_REMOTE_STORE_PATH_HASH_ALGORITHM_SETTING, CLUSTER_REMOTE_MAX_TRANSLOG_READERS, CLUSTER_REMOTE_STORE_TRANSLOG_METADATA);
        }
    }
}

