/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote;

import io.skylite.common.util.concurrent.ConcurrentCollections;
import io.skylite.core.index.remote.RemoteSegmentTransferTracker;
import io.skylite.core.index.remote.RemoteTranslogTransferTracker;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexEventListener;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.settings.ClusterSettings;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteStoreStatsTrackerFactory
implements IndexEventListener {
    public static final Setting<Integer> MOVING_AVERAGE_WINDOW_SIZE = Setting.intSetting("remote_store.moving_average_window_size", 20, 5, Setting.Property.Dynamic, Setting.Property.NodeScope);
    private static final Logger logger = LogManager.getLogger(RemoteStoreStatsTrackerFactory.class);
    private volatile int movingAverageWindowSize;
    private final Map<ShardId, RemoteSegmentTransferTracker> remoteSegmentTrackerMap = ConcurrentCollections.newConcurrentMap();
    private final Map<ShardId, RemoteTranslogTransferTracker> remoteTranslogTrackerMap = ConcurrentCollections.newConcurrentMap();

    public RemoteStoreStatsTrackerFactory(ClusterSettings clusterSettings, Settings settings) {
        this.movingAverageWindowSize = MOVING_AVERAGE_WINDOW_SIZE.get(settings);
        clusterSettings.addSettingsUpdateConsumer(MOVING_AVERAGE_WINDOW_SIZE, this::updateMovingAverageWindowSize);
    }

    @Override
    public void afterIndexShardCreated(BaseIndexShard indexShard) {
        if (!indexShard.indexSettings().isRemoteStoreEnabled() && !indexShard.indexSettings().isAssignedOnRemoteNode()) {
            return;
        }
        ShardId shardId = indexShard.shardId();
        this.remoteSegmentTrackerMap.put(shardId, new RemoteSegmentTransferTracker(shardId, indexShard.store().getDirectoryFileTransferTracker(), this.movingAverageWindowSize));
        logger.trace("Created RemoteSegmentTransferTracker for shardId={}", (Object)shardId);
        this.remoteTranslogTrackerMap.put(shardId, new RemoteTranslogTransferTracker(shardId, this.movingAverageWindowSize));
        logger.trace("Created RemoteTranslogTransferTracker for shardId={}", (Object)shardId);
    }

    @Override
    public void afterIndexShardClosed(ShardId shardId, BaseIndexShard indexShard, Settings indexSettings) {
        RemoteTranslogTransferTracker remoteTranslogTransferTracker;
        RemoteSegmentTransferTracker remoteSegmentTransferTracker = this.remoteSegmentTrackerMap.remove(shardId);
        if (remoteSegmentTransferTracker != null) {
            logger.trace("Deleted RemoteSegmentTransferTracker for shardId={}", (Object)shardId);
        }
        if ((remoteTranslogTransferTracker = this.remoteTranslogTrackerMap.remove(shardId)) != null) {
            logger.trace("Deleted RemoteTranslogTransferTracker for shardId={}", (Object)shardId);
        }
    }

    private void updateMovingAverageWindowSize(int updatedSize) {
        this.remoteSegmentTrackerMap.values().forEach(tracker -> tracker.updateMovingAverageWindowSize(updatedSize));
        this.remoteTranslogTrackerMap.values().forEach(tracker -> tracker.updateMovingAverageWindowSize(updatedSize));
        this.movingAverageWindowSize = updatedSize;
    }

    public RemoteSegmentTransferTracker getRemoteSegmentTransferTracker(ShardId shardId) {
        return this.remoteSegmentTrackerMap.get(shardId);
    }

    public RemoteTranslogTransferTracker getRemoteTranslogTransferTracker(ShardId shardId) {
        return this.remoteTranslogTrackerMap.get(shardId);
    }

    int getMovingAverageWindowSize() {
        return this.movingAverageWindowSize;
    }

    static class Defaults {
        static final int MOVING_AVERAGE_WINDOW_SIZE = 20;
        static final int MOVING_AVERAGE_WINDOW_SIZE_MIN_VALUE = 5;

        Defaults() {
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(MOVING_AVERAGE_WINDOW_SIZE);
        }
    }
}

