/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote.filecache;

import io.skylite.SkyliteExceptionsHelper;
import io.skylite.common.CheckedRunnable;
import io.skylite.common.cache.RemovalReason;
import io.skylite.common.cache.SegmentedCache;
import io.skylite.core.common.breaker.CircuitBreaker;
import io.skylite.core.index.remote.filecache.CachedIndexInput;
import io.skylite.core.index.remote.filecache.FileCache;
import java.nio.file.Files;
import java.nio.file.Path;

public class FileCacheFactory {
    public static FileCache createConcurrentLRUFileCache(long capacity, CircuitBreaker circuitBreaker) {
        return new FileCache((SegmentedCache<Path, CachedIndexInput>)FileCacheFactory.createDefaultBuilder().capacity(capacity).build(), circuitBreaker);
    }

    public static FileCache createConcurrentLRUFileCache(long capacity, int concurrencyLevel, CircuitBreaker circuitBreaker) {
        return new FileCache((SegmentedCache<Path, CachedIndexInput>)FileCacheFactory.createDefaultBuilder().capacity(capacity).concurrencyLevel(concurrencyLevel).build(), circuitBreaker);
    }

    private static SegmentedCache.Builder<Path, CachedIndexInput> createDefaultBuilder() {
        return SegmentedCache.builder().weigher(CachedIndexInput::length).listener(removalNotification -> {
            RemovalReason removalReason = removalNotification.getRemovalReason();
            CachedIndexInput value = (CachedIndexInput)removalNotification.getValue();
            Path key = (Path)removalNotification.getKey();
            if (removalReason != RemovalReason.REPLACED) {
                SkyliteExceptionsHelper.catchAsRuntimeException((CheckedRunnable<Exception>)((CheckedRunnable)value::close));
                SkyliteExceptionsHelper.catchAsRuntimeException(() -> Files.deleteIfExists(key));
            }
        });
    }
}

