/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.remote.utils;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.core.index.remote.filecache.CachedIndexInput;
import io.skylite.core.index.remote.filecache.FileCache;
import io.skylite.core.index.remote.filecache.FileCachedIndexInput;
import io.skylite.core.index.remote.utils.BlobFetchRequest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.AccessController;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public class TransferManager {
    private static final Logger logger = LogManager.getLogger(TransferManager.class);
    private final BlobContainer blobContainer;
    private final FileCache fileCache;

    public TransferManager(BlobContainer blobContainer, FileCache fileCache) {
        this.blobContainer = blobContainer;
        this.fileCache = fileCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IndexInput fetchBlob(BlobFetchRequest blobFetchRequest) throws IOException {
        Path key = blobFetchRequest.getFilePath();
        CachedIndexInput cacheEntry = this.fileCache.compute(key, (path, cachedIndexInput) -> {
            if (cachedIndexInput == null || cachedIndexInput.isClosed()) {
                return new DelayedCreationCachedIndexInput(this.fileCache, this.blobContainer, blobFetchRequest);
            }
            return cachedIndexInput;
        });
        try {
            IndexInput indexInput = cacheEntry.getIndexInput().clone();
            return indexInput;
        }
        finally {
            this.fileCache.decRef(key);
        }
    }

    private static FileCachedIndexInput createIndexInput(FileCache fileCache, BlobContainer blobContainer, BlobFetchRequest request) {
        return AccessController.doPrivileged(() -> {
            try {
                if (!Files.exists(request.getFilePath(), new LinkOption[0])) {
                    try (InputStream snapshotFileInputStream = blobContainer.readBlob(request.getBlobName(), request.getPosition(), request.getLength());
                         OutputStream fileOutputStream = Files.newOutputStream(request.getFilePath(), new OpenOption[0]);
                         BufferedOutputStream localFileOutputStream = new BufferedOutputStream(fileOutputStream);){
                        snapshotFileInputStream.transferTo(localFileOutputStream);
                    }
                }
                IndexInput luceneIndexInput = request.getDirectory().openInput(request.getFileName(), IOContext.DEFAULT);
                return new FileCachedIndexInput(fileCache, request.getFilePath(), luceneIndexInput);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private static class DelayedCreationCachedIndexInput
    implements CachedIndexInput {
        private final FileCache fileCache;
        private final BlobContainer blobContainer;
        private final BlobFetchRequest request;
        private final CompletableFuture<IndexInput> result = new CompletableFuture();
        private final AtomicBoolean isStarted = new AtomicBoolean(false);
        private final AtomicBoolean isClosed = new AtomicBoolean(false);

        private DelayedCreationCachedIndexInput(FileCache fileCache, BlobContainer blobContainer, BlobFetchRequest request) {
            this.fileCache = fileCache;
            this.blobContainer = blobContainer;
            this.request = request;
        }

        @Override
        public IndexInput getIndexInput() throws IOException {
            if (this.isClosed.get()) {
                throw new IllegalStateException("Already closed");
            }
            if (!this.isStarted.getAndSet(true)) {
                try {
                    this.result.complete(TransferManager.createIndexInput(this.fileCache, this.blobContainer, this.request));
                }
                catch (Exception e) {
                    this.result.completeExceptionally(e);
                    this.fileCache.remove(this.request.getFilePath());
                }
            }
            try {
                return this.result.join();
            }
            catch (CompletionException e) {
                if (e.getCause() instanceof UncheckedIOException) {
                    throw ((UncheckedIOException)e.getCause()).getCause();
                }
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public long length() {
            return this.request.getLength();
        }

        @Override
        public boolean isClosed() {
            return this.isClosed.get();
        }

        @Override
        public void close() throws Exception {
            if (!this.isClosed.getAndSet(true)) {
                this.result.whenComplete((indexInput, error) -> {
                    if (indexInput != null) {
                        try {
                            indexInput.close();
                        }
                        catch (IOException e) {
                            logger.warn("Error closing IndexInput", (Throwable)e);
                        }
                    }
                });
            }
        }
    }
}

