/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.seqno;

import io.skylite.core.ParseField;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.index.seqno.RetentionLease;
import io.skylite.core.xcontent.ConstructingObjectParser;
import io.skylite.core.xcontent.MetadataStateFormat;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import io.skylite.core.xcontent.XContentParser;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public class RetentionLeases
implements ToXContentFragment,
Writeable {
    private final long primaryTerm;
    private final long version;
    private final Map<String, RetentionLease> leases;
    public static RetentionLeases EMPTY = new RetentionLeases(1L, 0L, Collections.emptyList());
    private static final ParseField PRIMARY_TERM_FIELD = new ParseField("primary_term", new String[0]);
    private static final ParseField VERSION_FIELD = new ParseField("version", new String[0]);
    private static final ParseField LEASES_FIELD = new ParseField("leases", new String[0]);
    private static final ConstructingObjectParser<RetentionLeases, Void> PARSER = new ConstructingObjectParser("retention_leases", a -> new RetentionLeases((Long)a[0], (Long)a[1], (Collection)a[2]));
    static final MetadataStateFormat<RetentionLeases> FORMAT;

    public long primaryTerm() {
        return this.primaryTerm;
    }

    public long version() {
        return this.version;
    }

    boolean supersedes(RetentionLeases that) {
        return this.supersedes(that.primaryTerm, that.version);
    }

    boolean supersedes(long primaryTerm, long version) {
        return this.primaryTerm > primaryTerm || this.primaryTerm == primaryTerm && this.version > version;
    }

    public Collection<RetentionLease> leases() {
        return Collections.unmodifiableCollection(this.leases.values());
    }

    public boolean contains(String id) {
        return this.leases.containsKey(id);
    }

    public RetentionLease get(String id) {
        return this.leases.get(id);
    }

    public RetentionLeases(long primaryTerm, long version, Collection<RetentionLease> leases) {
        if (primaryTerm <= 0L) {
            throw new IllegalArgumentException("primary term must be positive but was [" + primaryTerm + "]");
        }
        if (version < 0L) {
            throw new IllegalArgumentException("version must be non-negative but was [" + version + "]");
        }
        Objects.requireNonNull(leases);
        this.primaryTerm = primaryTerm;
        this.version = version;
        this.leases = Collections.unmodifiableMap(RetentionLeases.toMap(leases));
    }

    public RetentionLeases(StreamInput in) throws IOException {
        this.primaryTerm = in.readVLong();
        this.version = in.readVLong();
        this.leases = Collections.unmodifiableMap(RetentionLeases.toMap(in.readList(RetentionLease::new)));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.primaryTerm);
        out.writeVLong(this.version);
        out.writeCollection(this.leases.values());
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(PRIMARY_TERM_FIELD.getPreferredName(), this.primaryTerm);
        builder.field(VERSION_FIELD.getPreferredName(), this.version);
        builder.startArray(LEASES_FIELD.getPreferredName());
        for (RetentionLease retentionLease : this.leases.values()) {
            retentionLease.toXContent(builder, params);
        }
        builder.endArray();
        return builder;
    }

    public static RetentionLeases fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetentionLeases that = (RetentionLeases)o;
        return this.primaryTerm == that.primaryTerm && this.version == that.version && Objects.equals(this.leases, that.leases);
    }

    public int hashCode() {
        return Objects.hash(this.primaryTerm, this.version, this.leases);
    }

    public String toString() {
        return "RetentionLeases{primaryTerm=" + this.primaryTerm + ", version=" + this.version + ", leases=" + String.valueOf(this.leases) + "}";
    }

    private static Map<String, RetentionLease> toMap(Collection<RetentionLease> leases) {
        return leases.stream().collect(Collectors.toMap(RetentionLease::id, Function.identity(), (left, right) -> {
            assert (left.id().equals(right.id())) : "expected [" + left.id() + "] to equal [" + right.id() + "]";
            throw new IllegalStateException("duplicate retention lease ID [" + left.id() + "]");
        }, LinkedHashMap::new));
    }

    static {
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), PRIMARY_TERM_FIELD);
        PARSER.declareLong(ConstructingObjectParser.constructorArg(), VERSION_FIELD);
        PARSER.declareObjectArray(ConstructingObjectParser.constructorArg(), (p, c) -> RetentionLease.fromXContent(p), LEASES_FIELD);
        FORMAT = new MetadataStateFormat<RetentionLeases>("retention-leases-"){

            @Override
            public void toXContent(XContentBuilder builder, RetentionLeases retentionLeases) throws IOException {
                retentionLeases.toXContent(builder, ToXContent.EMPTY_PARAMS);
            }

            @Override
            public RetentionLeases fromXContent(XContentParser parser) {
                return RetentionLeases.fromXContent(parser);
            }
        };
    }
}

