/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.common.UUIDs;
import io.skylite.common.action.ActionListener;
import io.skylite.common.unit.TimeValue;
import io.skylite.core.action.ActionListenerHelper;
import io.skylite.core.cluster.metadata.IndexMetadata;
import io.skylite.core.cluster.metadata.MappingMetadata;
import io.skylite.core.cluster.routing.RecoverySource;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.shard.BaseIndexShard;
import io.skylite.core.index.shard.IndexShardClosedException;
import io.skylite.core.index.shard.IndexShardNotStartedException;
import io.skylite.core.index.shard.IndexShardRecoveryException;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.LocalShardSnapshot;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardSplittingQuery;
import io.skylite.core.index.store.Store;
import io.skylite.core.index.translog.Translog;
import io.skylite.core.indices.recovery.RecoveryState;
import io.skylite.core.indices.replication.common.ReplicationLuceneIndex;
import io.skylite.core.lucene.XLucene;
import io.skylite.core.mapper.MergeReason;
import io.skylite.core.repositories.Repository;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.misc.store.HardlinkCopyDirectoryWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;

public abstract class BaseStoreRecovery {
    protected final Logger logger;
    protected final ShardId shardId;

    public BaseStoreRecovery(ShardId shardId, Logger logger) {
        this.logger = logger;
        this.shardId = shardId;
    }

    public void recoverFromStore(BaseIndexShard indexShard, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            ActionListenerHelper.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from store ...");
                this.internalRecoverFromStore(indexShard);
                return true;
            });
        } else {
            listener.onResponse((Object)false);
        }
    }

    public void recoverFromRemoteStore(BaseIndexShard indexShard, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.REMOTE_STORE) : "expected remote store recovery type but was: " + String.valueOf((Object)recoveryType);
            ActionListenerHelper.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from remote store ...");
                this.recoverFromRemoteStore(indexShard);
                return true;
            });
        } else {
            listener.onResponse((Object)false);
        }
    }

    public void recoverFromLocalShards(Consumer<MappingMetadata> mappingUpdateConsumer, BaseIndexShard indexShard, List<LocalShardSnapshot> shards, ActionListener<Boolean> listener) {
        if (this.canRecover(indexShard)) {
            RecoverySource.Type recoveryType = indexShard.recoveryState().getRecoverySource().getType();
            assert (recoveryType == RecoverySource.Type.LOCAL_SHARDS) : "expected local shards recovery type: " + String.valueOf((Object)recoveryType);
            if (shards.isEmpty()) {
                throw new IllegalArgumentException("shards must not be empty");
            }
            Set indices = shards.stream().map(s -> s.getIndex()).collect(Collectors.toSet());
            if (indices.size() > 1) {
                throw new IllegalArgumentException("can't add shards from more than one index");
            }
            IndexMetadata sourceMetadata = shards.get(0).getIndexMetadata();
            if (sourceMetadata.mapping() != null) {
                mappingUpdateConsumer.accept(sourceMetadata.mapping());
            }
            indexShard.mapperService().merge(sourceMetadata, MergeReason.MAPPING_RECOVERY);
            Sort indexSort = indexShard.getIndexSort();
            boolean hasNested = indexShard.mapperService().hasNested();
            boolean isSplit = sourceMetadata.getNumberOfShards() < indexShard.indexSettings().getNumberOfShards();
            ActionListenerHelper.completeWith(this.recoveryListener(indexShard, listener), () -> {
                this.logger.debug("starting recovery from local shards {}", (Object)shards);
                try {
                    Directory directory = indexShard.store().directory();
                    Directory[] sources = (Directory[])shards.stream().map(LocalShardSnapshot::getSnapshotDirectory).toArray(Directory[]::new);
                    long maxSeqNo = shards.stream().mapToLong(LocalShardSnapshot::maxSeqNo).max().getAsLong();
                    long maxUnsafeAutoIdTimestamp = shards.stream().mapToLong(LocalShardSnapshot::maxUnsafeAutoIdTimestamp).max().getAsLong();
                    this.addIndices(indexShard.recoveryState().getIndex(), directory, indexSort, sources, maxSeqNo, maxUnsafeAutoIdTimestamp, indexShard.indexSettings().getIndexMetadata(), indexShard.shardId().id(), isSplit, hasNested);
                    this.internalRecoverFromStore(indexShard);
                    indexShard.getEngine().forceMerge(false, -1, false, false, false, UUIDs.randomBase64UUID());
                    if (indexShard.isRemoteTranslogEnabled() && indexShard.shardRouting.primary()) {
                        indexShard.waitForRemoteStoreSync();
                        if (!indexShard.isRemoteSegmentStoreInSync()) {
                            throw new IndexShardRecoveryException(indexShard.shardId(), "failed to upload to remote", new IOException("Failed to upload to remote segment store"));
                        }
                    }
                    return true;
                }
                catch (IOException ex) {
                    throw new IndexShardRecoveryException(indexShard.shardId(), "failed to recover from local shards", ex);
                }
            });
        } else {
            listener.onResponse((Object)false);
        }
    }

    public void addIndices(ReplicationLuceneIndex indexRecoveryStats, Directory target, Sort indexSort, Directory[] sources, long maxSeqNo, long maxUnsafeAutoIdTimestamp, IndexMetadata indexMetadata, int shardId, boolean split, boolean hasNested) throws IOException {
        assert (sources.length > 0);
        int luceneIndexCreatedVersionMajor = XLucene.readSegmentInfos(sources[0]).getIndexCreatedVersionMajor();
        HardlinkCopyDirectoryWrapper hardLinkOrCopyTarget = new HardlinkCopyDirectoryWrapper(target);
        IndexWriterConfig iwc = new IndexWriterConfig(null).setSoftDeletesField("__soft_deletes").setCommitOnClose(false).setMergePolicy(NoMergePolicy.INSTANCE).setOpenMode(IndexWriterConfig.OpenMode.CREATE).setIndexCreatedVersionMajor(luceneIndexCreatedVersionMajor);
        if (indexSort != null) {
            iwc.setIndexSort(indexSort);
        }
        try (IndexWriter writer = new IndexWriter((Directory)new StatsDirectoryWrapper((Directory)hardLinkOrCopyTarget, indexRecoveryStats), iwc);){
            writer.addIndexes(sources);
            indexRecoveryStats.setFileDetailsComplete();
            if (split) {
                writer.deleteDocuments(new Query[]{new ShardSplittingQuery(indexMetadata, shardId, hasNested)});
            }
            writer.setLiveCommitData(() -> {
                HashMap<String, String> liveCommitData = new HashMap<String, String>(3);
                liveCommitData.put("max_seq_no", Long.toString(maxSeqNo));
                liveCommitData.put("local_checkpoint", Long.toString(maxSeqNo));
                liveCommitData.put("max_unsafe_auto_id_timestamp", Long.toString(maxUnsafeAutoIdTimestamp));
                return liveCommitData.entrySet().iterator();
            });
            writer.commit();
        }
    }

    protected boolean canRecover(BaseIndexShard indexShard) {
        if (indexShard.state() == IndexShardState.CLOSED) {
            return false;
        }
        if (!indexShard.routingEntry().primary()) {
            throw new IndexShardRecoveryException(this.shardId, "Trying to recover when the shard is in backup state", null);
        }
        return true;
    }

    protected ActionListener<Boolean> recoveryListener(BaseIndexShard indexShard, ActionListener<Boolean> listener) {
        return ActionListenerHelper.wrap(res -> {
            if (res.booleanValue()) {
                IndexShardState shardState = indexShard.state();
                RecoveryState recoveryState = indexShard.recoveryState();
                assert (shardState != IndexShardState.CREATED && shardState != IndexShardState.RECOVERING) : "recovery process of " + String.valueOf(this.shardId) + " didn't get to post_recovery. shardState [" + String.valueOf((Object)shardState) + "]";
                if (this.logger.isTraceEnabled()) {
                    ReplicationLuceneIndex index = recoveryState.getIndex();
                    StringBuilder sb = new StringBuilder();
                    sb.append("    index    : files           [").append(index.totalFileCount()).append("] with total_size [").append(new ByteSizeValue(index.totalBytes())).append("], took[").append(TimeValue.timeValueMillis((long)index.time())).append("]\n");
                    sb.append("             : recovered_files [").append(index.recoveredFileCount()).append("] with total_size [").append(new ByteSizeValue(index.recoveredBytes())).append("]\n");
                    sb.append("             : reusing_files   [").append(index.reusedFileCount()).append("] with total_size [").append(new ByteSizeValue(index.reusedBytes())).append("]\n");
                    sb.append("    verify_index    : took [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().time())).append("], check_index [").append(TimeValue.timeValueMillis((long)recoveryState.getVerifyIndex().checkIndexTime())).append("]\n");
                    sb.append("    translog : number_of_operations [").append(recoveryState.getTranslog().recoveredOperations()).append("], took [").append(TimeValue.timeValueMillis((long)recoveryState.getTranslog().time())).append("]");
                    this.logger.trace("recovery completed from [shard_store], took [{}]\n{}", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()), (Object)sb);
                } else if (this.logger.isDebugEnabled()) {
                    this.logger.debug("recovery completed from [shard_store], took [{}]", (Object)TimeValue.timeValueMillis((long)recoveryState.getTimer().time()));
                }
            }
            listener.onResponse(res);
        }, ex -> {
            if (ex instanceof IndexShardRecoveryException) {
                if (indexShard.state() == IndexShardState.CLOSED) {
                    listener.onResponse((Object)false);
                    return;
                }
                if (ex.getCause() instanceof IndexShardClosedException || ex.getCause() instanceof IndexShardNotStartedException) {
                    listener.onResponse((Object)false);
                    return;
                }
                listener.onFailure(ex);
            } else if (ex instanceof IndexShardClosedException || ex instanceof IndexShardNotStartedException) {
                listener.onResponse((Object)false);
            } else if (indexShard.state() == IndexShardState.CLOSED) {
                listener.onResponse((Object)false);
            } else {
                listener.onFailure((Exception)new IndexShardRecoveryException(this.shardId, "failed recovery", (Throwable)ex));
            }
        });
    }

    protected abstract void recoverFromRemoteStore(BaseIndexShard var1) throws IndexShardRecoveryException;

    protected abstract void internalRecoverFromStore(BaseIndexShard var1) throws IndexShardRecoveryException;

    protected static void writeEmptyRetentionLeasesFile(BaseIndexShard indexShard) throws IOException {
        assert (indexShard.getRetentionLeases().leases().isEmpty()) : indexShard.getRetentionLeases();
        indexShard.persistRetentionLeases();
        assert (indexShard.loadRetentionLeases().leases().isEmpty());
    }

    protected void addRecoveredFileDetails(SegmentInfos si, Store store, ReplicationLuceneIndex index) throws IOException {
        Directory directory = store.directory();
        for (String name : XLucene.files(si)) {
            long length = directory.fileLength(name);
            index.addFileDetail(name, length, true);
        }
    }

    protected abstract void restore(BaseIndexShard var1, Repository var2, RecoverySource.SnapshotRecoverySource var3, ActionListener<Boolean> var4);

    protected void bootstrapForSnapshot(BaseIndexShard indexShard, Store store) throws IOException {
        store.bootstrapNewHistory();
        SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
        long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
        String translogUUID = (String)store.readLastCommittedSegmentsInfo().getUserData().get("translog_uuid");
        Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), this.shardId, localCheckpoint, indexShard.getPendingPrimaryTerm(), translogUUID, FileChannel::open);
    }

    protected void bootstrap(BaseIndexShard indexShard, Store store) throws IOException {
        store.bootstrapNewHistory();
        SegmentInfos segmentInfos = store.readLastCommittedSegmentsInfo();
        long localCheckpoint = Long.parseLong((String)segmentInfos.userData.get("local_checkpoint"));
        String translogUUID = Translog.createEmptyTranslog(indexShard.shardPath().resolveTranslog(), localCheckpoint, this.shardId, indexShard.getPendingPrimaryTerm());
        store.associateIndexWithNewTranslog(translogUUID);
    }

    public static final class StatsDirectoryWrapper
    extends FilterDirectory {
        private final ReplicationLuceneIndex index;

        public StatsDirectoryWrapper(Directory in, ReplicationLuceneIndex indexRecoveryStats) {
            super(in);
            this.index = indexRecoveryStats;
        }

        public void copyFrom(Directory from, String src, final String dest, IOContext context) throws IOException {
            final long l = from.fileLength(src);
            final AtomicBoolean copies = new AtomicBoolean(false);
            this.in.copyFrom((Directory)new FilterDirectory(from){

                public IndexInput openInput(String name, IOContext context) throws IOException {
                    if (index.getFileDetails(dest) == null) {
                        index.addFileDetail(dest, l, false);
                    }
                    copies.set(true);
                    final IndexInput input = this.in.openInput(name, context);
                    return new IndexInput("StatsDirectoryWrapper(" + input.toString() + ")"){

                        public void close() throws IOException {
                            input.close();
                        }

                        public long getFilePointer() {
                            throw new UnsupportedOperationException("only straight copies are supported");
                        }

                        public void seek(long pos) throws IOException {
                            throw new UnsupportedOperationException("seeks are not supported");
                        }

                        public long length() {
                            return input.length();
                        }

                        public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
                            throw new UnsupportedOperationException("slices are not supported");
                        }

                        public byte readByte() throws IOException {
                            throw new UnsupportedOperationException("use a buffer if you wanna perform well");
                        }

                        public void readBytes(byte[] b, int offset, int len) throws IOException {
                            input.readBytes(b, offset, len);
                            index.addRecoveredBytesToFile(dest, len);
                        }
                    };
                }
            }, src, dest, context);
            if (!copies.get() && this.index.getFileDetails(dest) == null) {
                this.index.addFileDetail(dest, l, true);
            } else {
                assert (this.index.getFileDetails(dest) != null) : "File [" + dest + "] has no file details";
                assert (this.index.getFileDetails(dest).recovered() == l) : this.index.getFileDetails(dest).toString();
            }
        }

        public Set<String> getPendingDeletions() throws IOException {
            return this.in.getPendingDeletions();
        }
    }
}

