/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.SkyliteException;
import io.skylite.SkyliteExceptionProvider;
import io.skylite.Version;
import io.skylite.common.CheckedFunction;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.rest.RestStatus;
import java.io.IOException;

public class IllegalIndexShardStateException
extends SkyliteException {
    private final IndexShardState currentState;

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Object ... args) {
        this(shardId, currentState, msg, null, args);
    }

    public IllegalIndexShardStateException(ShardId shardId, IndexShardState currentState, String msg, Throwable ex, Object ... args) {
        super("CurrentState[" + String.valueOf((Object)currentState) + "] " + msg, ex, args);
        this.setShard(shardId);
        this.currentState = currentState;
    }

    public IndexShardState currentState() {
        return this.currentState;
    }

    public IllegalIndexShardStateException(StreamInput in) throws IOException {
        super(in);
        this.currentState = IndexShardState.fromId(in.readByte());
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeByte(this.currentState.id());
    }

    @Override
    public RestStatus status() {
        return RestStatus.NOT_FOUND;
    }

    public static class Registration
    implements SkyliteExceptionProvider<IllegalIndexShardStateException> {
        @Override
        public Class<IllegalIndexShardStateException> getExceptionClass() {
            return IllegalIndexShardStateException.class;
        }

        @Override
        public CheckedFunction<StreamInput, IllegalIndexShardStateException, IOException> getConstructor() {
            return IllegalIndexShardStateException::new;
        }

        @Override
        public Version<?> getVersionAdded() {
            return SkyliteException.UNKNOWN_VERSION_ADDED;
        }

        @Override
        public int getLegacyId() {
            return 97;
        }
    }
}

