/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.index.shard.ShardId;
import java.util.List;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

public interface IndexingOperationListener {
    default public EngineOperation.Index preIndex(ShardId shardId, EngineOperation.Index operation) {
        return operation;
    }

    default public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
    }

    default public void postIndex(ShardId shardId, EngineOperation.Index index, Exception ex) {
    }

    default public EngineOperation.Delete preDelete(ShardId shardId, EngineOperation.Delete delete) {
        return delete;
    }

    default public void postDelete(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
    }

    default public void postDelete(ShardId shardId, EngineOperation.Delete delete, Exception ex) {
    }

    public static final class CompositeListener
    implements IndexingOperationListener {
        private final List<IndexingOperationListener> listeners;
        private final Logger logger;

        public CompositeListener(List<IndexingOperationListener> listeners, Logger logger) {
            this.listeners = listeners;
            this.logger = logger;
        }

        @Override
        public EngineOperation.Index preIndex(ShardId shardId, EngineOperation.Index operation) {
            assert (operation != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preIndex(shardId, operation);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return operation;
        }

        @Override
        public void postIndex(ShardId shardId, EngineOperation.Index index, EngineResult.IndexResult result) {
            assert (index != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postIndex(ShardId shardId, EngineOperation.Index index, Exception ex) {
            assert (index != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postIndex(shardId, index, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postIndex listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }

        @Override
        public EngineOperation.Delete preDelete(ShardId shardId, EngineOperation.Delete delete) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.preDelete(shardId, delete);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("preDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
            return delete;
        }

        @Override
        public void postDelete(ShardId shardId, EngineOperation.Delete delete, EngineResult.DeleteResult result) {
            assert (delete != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, result);
                }
                catch (Exception e) {
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)e);
                }
            }
        }

        @Override
        public void postDelete(ShardId shardId, EngineOperation.Delete delete, Exception ex) {
            assert (delete != null && ex != null);
            for (IndexingOperationListener listener : this.listeners) {
                try {
                    listener.postDelete(shardId, delete, ex);
                }
                catch (Exception inner) {
                    inner.addSuppressed(ex);
                    this.logger.warn(() -> new ParameterizedMessage("postDelete listener [{}] failed", (Object)listener), (Throwable)inner);
                }
            }
        }
    }
}

