/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.common.collect.Tuple;
import io.skylite.common.lease.Releasable;
import io.skylite.common.metrics.MeanMetric;
import io.skylite.common.util.concurrent.RunOnce;
import io.skylite.core.common.concurrent.ThreadContext;
import io.skylite.core.index.translog.TranslogLocation;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.ReferenceManager;

public final class RefreshListeners
implements ReferenceManager.RefreshListener,
Closeable {
    private final IntSupplier getMaxRefreshListeners;
    private final Runnable forceRefresh;
    private final Logger logger;
    private final ThreadContext threadContext;
    private final MeanMetric refreshMetric;
    private long currentRefreshStartTime;
    private volatile boolean closed = false;
    private int refreshForcers;
    private volatile List<Tuple<TranslogLocation, Consumer<Boolean>>> refreshListeners = null;
    private volatile TranslogLocation lastRefreshedLocation;
    private TranslogLocation currentRefreshLocation;
    private Supplier<TranslogLocation> currentRefreshLocationSupplier;

    public RefreshListeners(IntSupplier getMaxRefreshListeners, Runnable forceRefresh, Logger logger, ThreadContext threadContext, MeanMetric refreshMetric) {
        this.getMaxRefreshListeners = getMaxRefreshListeners;
        this.forceRefresh = forceRefresh;
        this.logger = logger;
        this.threadContext = threadContext;
        this.refreshMetric = refreshMetric;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Releasable forceRefreshes() {
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            assert (this.refreshForcers >= 0);
            ++this.refreshForcers;
        }
        RunOnce runOnce = new RunOnce(() -> {
            RefreshListeners refreshListeners = this;
            synchronized (refreshListeners) {
                assert (this.refreshForcers > 0);
                --this.refreshForcers;
            }
        });
        if (this.refreshNeeded()) {
            try {
                this.forceRefresh.run();
            }
            catch (Exception e) {
                runOnce.run();
                throw e;
            }
        }
        assert (this.refreshListeners == null);
        return () -> runOnce.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(TranslogLocation location, Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        if (this.lastRefreshedLocation != null && this.lastRefreshedLocation.compareTo(location) >= 0) {
            listener.accept(false);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            if (this.closed) {
                throw new IllegalStateException("can't wait for refresh on a closed index");
            }
            List<Tuple<TranslogLocation, Consumer<Boolean>>> listeners = this.refreshListeners;
            int maxRefreshes = this.getMaxRefreshListeners.getAsInt();
            if (this.refreshForcers == 0 && maxRefreshes > 0 && (listeners == null || listeners.size() < maxRefreshes)) {
                ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext(true);
                Consumer<Boolean> contextPreservingListener = forced -> {
                    try (ThreadContext.StoredContext ignore = this.threadContext.stashContext();){
                        storedContext.restore();
                        listener.accept((Boolean)forced);
                    }
                };
                if (listeners == null) {
                    listeners = new ArrayList<Tuple<TranslogLocation, Consumer<Boolean>>>();
                }
                listeners.add((Tuple<TranslogLocation, Consumer<Boolean>>)new Tuple((Object)location, contextPreservingListener));
                this.refreshListeners = listeners;
                return false;
            }
        }
        this.forceRefresh.run();
        listener.accept(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<Tuple<TranslogLocation, Consumer<Boolean>>> oldListeners;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            oldListeners = this.refreshListeners;
            this.refreshListeners = null;
            this.closed = true;
        }
        this.fireListeners(oldListeners);
    }

    public boolean refreshNeeded() {
        return this.refreshListeners != null && false == this.closed;
    }

    public int pendingCount() {
        List<Tuple<TranslogLocation, Consumer<Boolean>>> listeners = this.refreshListeners;
        return listeners == null ? 0 : listeners.size();
    }

    public void setCurrentRefreshLocationSupplier(Supplier<TranslogLocation> currentRefreshLocationSupplier) {
        this.currentRefreshLocationSupplier = currentRefreshLocationSupplier;
    }

    public void beforeRefresh() throws IOException {
        this.currentRefreshLocation = this.currentRefreshLocationSupplier.get();
        this.currentRefreshStartTime = System.nanoTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterRefresh(boolean didRefresh) throws IOException {
        List<Tuple<TranslogLocation, Consumer<Boolean>>> candidates;
        this.refreshMetric.inc(System.nanoTime() - this.currentRefreshStartTime);
        if (null == this.currentRefreshLocation) {
            return;
        }
        this.lastRefreshedLocation = this.currentRefreshLocation;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            candidates = this.refreshListeners;
            if (candidates == null) {
                return;
            }
            this.refreshListeners = null;
        }
        ArrayList<Tuple<TranslogLocation, Consumer<Boolean>>> listenersToFire = null;
        ArrayList<Tuple<TranslogLocation, Consumer<Boolean>>> preservedListeners = null;
        for (Tuple<TranslogLocation, Consumer<Boolean>> tuple : candidates) {
            TranslogLocation location = (TranslogLocation)tuple.v1();
            if (location.compareTo(this.currentRefreshLocation) <= 0) {
                if (listenersToFire == null) {
                    listenersToFire = new ArrayList<Tuple<TranslogLocation, Consumer<Boolean>>>();
                }
                listenersToFire.add(tuple);
                continue;
            }
            if (preservedListeners == null) {
                preservedListeners = new ArrayList<Tuple<TranslogLocation, Consumer<Boolean>>>();
            }
            preservedListeners.add(tuple);
        }
        if (preservedListeners != null) {
            RefreshListeners refreshListeners2 = this;
            synchronized (refreshListeners2) {
                if (this.refreshListeners == null) {
                    if (this.closed) {
                        listenersToFire.addAll(preservedListeners);
                    } else {
                        this.refreshListeners = preservedListeners;
                    }
                } else {
                    assert (!this.closed) : "Can't be closed and have non-null refreshListeners";
                    this.refreshListeners.addAll(preservedListeners);
                }
            }
        }
        this.fireListeners(listenersToFire);
    }

    private void fireListeners(List<Tuple<TranslogLocation, Consumer<Boolean>>> listenersToFire) {
        if (listenersToFire != null) {
            for (Tuple<TranslogLocation, Consumer<Boolean>> listener : listenersToFire) {
                try {
                    ((Consumer)listener.v2()).accept(false);
                }
                catch (Exception e) {
                    this.logger.warn("error firing refresh listener", (Throwable)e);
                }
            }
        }
    }
}

