/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.shard;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.indices.replication.common.ReplicationTimer;
import java.io.IOException;

public class SegmentReplicationLagTimer
extends ReplicationTimer {
    private long creationTime;

    public SegmentReplicationLagTimer() {
        this.creationTime = System.nanoTime();
    }

    public SegmentReplicationLagTimer(StreamInput in) throws IOException {
        super(in);
        this.creationTime = in.readVLong();
    }

    @Override
    public synchronized void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeVLong(this.creationTime);
    }

    public long totalElapsedTime() {
        return TimeValue.nsecToMSec((long)Math.max(System.nanoTime() - this.creationTime, 0L));
    }
}

