/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.similarity;

import io.skylite.Version;
import io.skylite.common.TriFunction;
import io.skylite.core.index.similarity.ScriptedSimilarity;
import io.skylite.core.script.Script;
import io.skylite.core.script.ScriptService;
import io.skylite.core.script.SimilarityScript;
import io.skylite.core.script.SimilarityWeightScript;
import io.skylite.core.settings.Settings;
import org.apache.lucene.search.similarities.Similarity;

public final class ScriptedSimilarityProvider
implements TriFunction<Settings, Version, Object, Similarity> {
    public Similarity apply(Settings settings, Version indexCreatedVersion, Object scriptServiceObj) {
        if (!(scriptServiceObj instanceof ScriptService)) {
            throw new IllegalArgumentException("should be a script service");
        }
        ScriptService scriptService = (ScriptService)ScriptService.class.cast(scriptServiceObj);
        boolean discountOverlaps = settings.getAsBoolean("discount_overlaps", true);
        Settings scriptSettings = settings.getAsSettings("script");
        Script script = Script.parse(scriptSettings);
        SimilarityScript.Factory scriptFactory = scriptService.compile(script, SimilarityScript.CONTEXT);
        Settings weightScriptSettings = settings.getAsSettings("weight_script");
        Script weightScript = null;
        SimilarityWeightScript.Factory weightScriptFactory = null;
        if (!weightScriptSettings.isEmpty()) {
            weightScript = Script.parse(weightScriptSettings);
            weightScriptFactory = scriptService.compile(weightScript, SimilarityWeightScript.CONTEXT);
        }
        return new ScriptedSimilarity(weightScript == null ? null : weightScript.toString(), weightScriptFactory == null ? null : weightScriptFactory::newInstance, script.toString(), scriptFactory::newInstance, discountOverlaps);
    }
}

