/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store;

import io.skylite.common.util.io.IOUtils;
import io.skylite.core.index.IndexModuleSettings;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.store.IndexStoreSettings;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.Settings;
import io.skylite.core.settings.spi.SettingsProvider;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.store.DataAccessHint;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.FileSwitchDirectory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.NativeFSLockFactory;
import org.apache.lucene.store.ReadOnceHint;
import org.apache.lucene.store.SimpleFSLockFactory;

public class FsDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    public static final IOContext READONCE_CHECKSUM = FsDirectoryFactory.createReadOnceContext();
    public static final Setting<LockFactory> INDEX_LOCK_FACTOR_SETTING = new Setting<LockFactory>("index.store.fs.fs_lock", "native", s -> {
        switch (s) {
            case "native": {
                return NativeFSLockFactory.INSTANCE;
            }
            case "simple": {
                return SimpleFSLockFactory.INSTANCE;
            }
        }
        throw new IllegalArgumentException("unrecognized [index.store.fs.fs_lock] \"" + s + "\": must be native or simple");
    }, Setting.Property.IndexScope, Setting.Property.NodeScope);

    private static IOContext createReadOnceContext() {
        IOContext context = IOContext.READONCE.withHints(new IOContext.FileOpenHint[]{DataAccessHint.SEQUENTIAL, ReadOnceHint.INSTANCE});
        assert (context != IOContext.READONCE);
        assert (context.equals((Object)IOContext.READONCE));
        return context;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        Path location = path.resolveIndex();
        LockFactory lockFactory = indexSettings.getValue(INDEX_LOCK_FACTOR_SETTING);
        Files.createDirectories(location, new FileAttribute[0]);
        return this.newFSDirectory(location, lockFactory, indexSettings);
    }

    protected Directory newFSDirectory(Path location, LockFactory lockFactory, IndexSettings indexSettings) throws IOException {
        String storeType = indexSettings.getSettings().get(IndexStoreSettings.INDEX_STORE_TYPE_SETTING.getKey(), IndexModuleSettings.Type.FS.getSettingsKey());
        IndexModuleSettings.Type type = IndexModuleSettings.Type.FS.match(storeType) ? IndexModuleSettings.defaultStoreType(IndexStoreSettings.NODE_STORE_ALLOW_MMAP.get(indexSettings.getNodeSettings())) : IndexModuleSettings.Type.fromSettingsKey(storeType);
        HashSet<String> preLoadExtensions = new HashSet<String>((Collection)indexSettings.getValue(IndexStoreSettings.INDEX_STORE_PRE_LOAD_SETTING));
        switch (type) {
            case HYBRIDFS: {
                FSDirectory primaryDirectory = FSDirectory.open((Path)location, (LockFactory)lockFactory);
                Set mmapExtensions = Set.copyOf((Collection)indexSettings.getValue(IndexStoreSettings.INDEX_STORE_HYBRID_MMAP_EXTENSIONS));
                Set<Object> nioExtensions = !mmapExtensions.equals(new HashSet(IndexStoreSettings.INDEX_STORE_HYBRID_MMAP_EXTENSIONS.getDefault(Settings.EMPTY))) ? Stream.concat(IndexStoreSettings.INDEX_STORE_HYBRID_NIO_EXTENSIONS.getDefault(Settings.EMPTY).stream(), IndexStoreSettings.INDEX_STORE_HYBRID_MMAP_EXTENSIONS.getDefault(Settings.EMPTY).stream()).filter(e -> !mmapExtensions.contains(e)).collect(Collectors.toUnmodifiableSet()) : Set.copyOf((Collection)indexSettings.getValue(IndexStoreSettings.INDEX_STORE_HYBRID_NIO_EXTENSIONS));
                if (primaryDirectory instanceof MMapDirectory) {
                    MMapDirectory mMapDirectory = (MMapDirectory)primaryDirectory;
                    return new HybridDirectory(lockFactory, this.setPreload(mMapDirectory, preLoadExtensions), nioExtensions);
                }
                return primaryDirectory;
            }
            case MMAPFS: {
                return this.setPreload(new MMapDirectory(location, lockFactory), preLoadExtensions);
            }
            case SIMPLEFS: 
            case NIOFS: {
                return new NIOFSDirectory(location, lockFactory);
            }
        }
        throw new AssertionError((Object)("unexpected built-in store type [" + String.valueOf((Object)type) + "]"));
    }

    public MMapDirectory setPreload(MMapDirectory mMapDirectory, Set<String> preLoadExtensions) {
        mMapDirectory.setPreload(FsDirectoryFactory.getPreloadFunc(preLoadExtensions));
        return mMapDirectory;
    }

    static BiPredicate<String, IOContext> getPreloadFunc(Set<String> preLoadExtensions) {
        if (!preLoadExtensions.isEmpty()) {
            if (preLoadExtensions.contains("*")) {
                return MMapDirectory.ALL_FILES;
            }
            return (name, context) -> preLoadExtensions.contains(FileSwitchDirectory.getExtension((String)name));
        }
        return MMapDirectory.NO_FILES;
    }

    public static boolean isHybridFs(Directory directory) {
        Directory unwrap = FilterDirectory.unwrap((Directory)directory);
        return unwrap instanceof HybridDirectory;
    }

    static final class HybridDirectory
    extends NIOFSDirectory {
        private final MMapDirectory delegate;
        private final Set<String> nioExtensions;

        HybridDirectory(LockFactory lockFactory, MMapDirectory delegate, Set<String> nioExtensions) throws IOException {
            super(delegate.getDirectory(), lockFactory);
            this.delegate = delegate;
            this.nioExtensions = nioExtensions;
        }

        public IndexInput openInput(String name, IOContext context) throws IOException {
            if (this.useDelegate(name)) {
                this.ensureOpen();
                this.ensureCanRead(name);
                context = context == READONCE_CHECKSUM ? IOContext.READONCE : context;
                return this.delegate.openInput(name, context);
            }
            return super.openInput(name, context);
        }

        boolean useDelegate(String name) {
            String extension = FileSwitchDirectory.getExtension((String)name);
            return !this.nioExtensions.contains(extension);
        }

        public void close() throws IOException {
            IOUtils.close((Closeable[])new Closeable[]{() -> super.close(), this.delegate});
        }

        MMapDirectory getDelegate() {
            return this.delegate;
        }
    }

    public static class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Collections.singletonList(INDEX_LOCK_FACTOR_SETTING);
        }
    }
}

