/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote;

import io.skylite.common.blobstore.BlobContainer;
import io.skylite.core.common.io.stream.BytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.index.store.remote.RemoteIndexOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.OutputStreamIndexOutput;

public class RemoteBufferedIndexOutput
extends RemoteIndexOutput {
    private final BytesStreamOutput out;
    private final OutputStreamIndexOutput indexOutputBuffer;
    static final int BUFFER_SIZE = 4096;

    public RemoteBufferedIndexOutput(String name, BlobContainer blobContainer, int bufferSize) {
        super(name, blobContainer);
        this.out = new BytesStreamOutput();
        this.indexOutputBuffer = new OutputStreamIndexOutput(name, name, (OutputStream)this.out, bufferSize);
    }

    public RemoteBufferedIndexOutput(String name, BlobContainer blobContainer) {
        this(name, blobContainer, 4096);
    }

    RemoteBufferedIndexOutput(String name, BlobContainer blobContainer, BytesStreamOutput out, OutputStreamIndexOutput indexOutputBuffer) {
        super(name, blobContainer);
        this.out = out;
        this.indexOutputBuffer = indexOutputBuffer;
    }

    @Override
    public void copyBytes(DataInput input, long numBytes) throws IOException {
        this.indexOutputBuffer.copyBytes(input, numBytes);
    }

    @Override
    public void close() throws IOException {
        try (BytesStreamOutput outStream = this.out;
             StreamInput stream = this.out.bytes().streamInput();){
            this.indexOutputBuffer.close();
            this.blobContainer.writeBlob(this.getName(), (InputStream)stream, (long)this.out.bytes().length(), false);
        }
    }

    @Override
    public void writeByte(byte b) throws IOException {
        this.indexOutputBuffer.writeByte(b);
    }

    @Override
    public void writeBytes(byte[] byteArray, int offset, int length) throws IOException {
        this.indexOutputBuffer.writeBytes(byteArray, offset, length);
    }

    @Override
    public long getFilePointer() {
        return this.indexOutputBuffer.getFilePointer();
    }

    @Override
    public long getChecksum() throws IOException {
        return this.indexOutputBuffer.getChecksum();
    }
}

