/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote;

import io.skylite.common.blobstore.BlobPath;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.remote.RemoteStoreEnums;
import io.skylite.core.index.remote.RemoteStorePathStrategy;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.shard.ShardPath;
import io.skylite.core.index.store.remote.RemoteDirectory;
import io.skylite.core.index.store.remote.RemoteSegmentStoreDirectory;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreLockManagerFactory;
import io.skylite.core.index.store.remote.lockmanager.RemoteStoreMetadataLockManager;
import io.skylite.core.plugins.IndexStorePlugin;
import io.skylite.core.repositories.RepositoriesService;
import io.skylite.core.repositories.Repository;
import io.skylite.core.repositories.RepositoryMissingException;
import io.skylite.core.repositories.blobstore.BlobStoreRepository;
import io.skylite.core.threadpool.ThreadPool;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.lucene.store.Directory;

public class RemoteSegmentStoreDirectoryFactory
implements IndexStorePlugin.DirectoryFactory {
    private final Supplier<RepositoriesService> repositoriesService;
    private final ThreadPool threadPool;

    public RemoteSegmentStoreDirectoryFactory(Supplier<RepositoriesService> repositoriesService, ThreadPool threadPool) {
        this.repositoriesService = repositoriesService;
        this.threadPool = threadPool;
    }

    @Override
    public Directory newDirectory(IndexSettings indexSettings, ShardPath path) throws IOException {
        String repositoryName = indexSettings.getRemoteStoreRepository();
        String indexUUID = indexSettings.getIndex().getUUID();
        return this.newDirectory(repositoryName, indexUUID, path.getShardId(), indexSettings.getRemoteStorePathStrategy());
    }

    public Directory newDirectory(String repositoryName, String indexUUID, ShardId shardId, RemoteStorePathStrategy pathStrategy) throws IOException {
        RemoteSegmentStoreDirectory remoteSegmentStoreDirectory;
        block10: {
            assert (Objects.nonNull(pathStrategy));
            Repository repository = this.repositoriesService.get().repository(repositoryName);
            try {
                assert (repository instanceof BlobStoreRepository) : "repository should be instance of BlobStoreRepository";
                BlobStoreRepository blobStoreRepository = (BlobStoreRepository)repository;
                BlobPath repositoryBasePath = blobStoreRepository.basePath();
                String shardIdStr = String.valueOf(shardId.id());
                RemoteStorePathStrategy.PathInput dataPathInput = RemoteStorePathStrategy.PathInput.builder().basePath(repositoryBasePath).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.DATA).build();
                BlobPath dataPath = pathStrategy.generatePath(dataPathInput);
                RemoteDirectory dataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(dataPath), blobStoreRepository::maybeRateLimitRemoteUploadTransfers, blobStoreRepository::maybeRateLimitRemoteDownloadTransfers);
                RemoteStorePathStrategy.PathInput mdPathInput = RemoteStorePathStrategy.PathInput.builder().basePath(repositoryBasePath).indexUUID(indexUUID).shardId(shardIdStr).dataCategory(RemoteStoreEnums.DataCategory.SEGMENTS).dataType(RemoteStoreEnums.DataType.METADATA).build();
                BlobPath mdPath = pathStrategy.generatePath(mdPathInput);
                RemoteDirectory metadataDirectory = new RemoteDirectory(blobStoreRepository.blobStore().blobContainer(mdPath));
                RemoteStoreMetadataLockManager mdLockManager = RemoteStoreLockManagerFactory.newLockManager(this.repositoriesService.get(), repositoryName, indexUUID, shardIdStr, pathStrategy);
                remoteSegmentStoreDirectory = new RemoteSegmentStoreDirectory(dataDirectory, metadataDirectory, mdLockManager, this.threadPool, shardId);
                if (repository == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (repository != null) {
                        try {
                            repository.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (RepositoryMissingException e) {
                    throw new IllegalArgumentException("Repository should be created before creating index with remote_store enabled setting", e);
                }
            }
            repository.close();
        }
        return remoteSegmentStoreDirectory;
    }
}

