/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote.file;

import io.skylite.core.index.remote.utils.BlobFetchRequest;
import io.skylite.core.index.remote.utils.TransferManager;
import io.skylite.core.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import io.skylite.core.index.store.remote.file.OnDemandBlockIndexInput;
import java.io.IOException;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IndexInput;

public class OnDemandBlockSnapshotIndexInput
extends OnDemandBlockIndexInput {
    final TransferManager transferManager;
    protected final BlobStoreIndexShardSnapshot.FileInfo fileInfo;
    protected final FSDirectory directory;
    protected final String fileName;
    protected final long partSize;
    protected final long originalFileSize;

    public OnDemandBlockSnapshotIndexInput(BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        this("BlockedSnapshotIndexInput(path=\"" + directory.getDirectory().toString() + "/" + fileInfo.physicalName() + "\", offset=0, length= " + fileInfo.length() + ")", fileInfo, 0L, fileInfo.length(), false, directory, transferManager);
    }

    public OnDemandBlockSnapshotIndexInput(String resourceDescription, BlobStoreIndexShardSnapshot.FileInfo fileInfo, long offset, long length, boolean isClone, FSDirectory directory, TransferManager transferManager) {
        this(OnDemandBlockIndexInput.builder().resourceDescription(resourceDescription).isClone(isClone).offset(offset).length(length), fileInfo, directory, transferManager);
    }

    OnDemandBlockSnapshotIndexInput(OnDemandBlockIndexInput.Builder builder, BlobStoreIndexShardSnapshot.FileInfo fileInfo, FSDirectory directory, TransferManager transferManager) {
        super(builder);
        this.transferManager = transferManager;
        this.fileInfo = fileInfo;
        this.partSize = fileInfo.partSize() != null ? fileInfo.partSize().getBytes() : Long.MAX_VALUE;
        this.fileName = fileInfo.physicalName();
        this.directory = directory;
        this.originalFileSize = fileInfo.length();
    }

    @Override
    protected OnDemandBlockSnapshotIndexInput buildSlice(String sliceDescription, long offset, long length) {
        return new OnDemandBlockSnapshotIndexInput(OnDemandBlockIndexInput.builder().blockSizeShift(this.blockSizeShift).isClone(true).offset(this.offset + offset).length(length).resourceDescription(sliceDescription), this.fileInfo, this.directory, this.transferManager);
    }

    @Override
    protected IndexInput fetchBlock(int blockId) throws IOException {
        String blockFileName = this.fileName + "." + blockId;
        long blockStart = this.getBlockStart(blockId);
        long blockEnd = blockStart + this.getActualBlockSize(blockId);
        int part = (int)(blockStart / this.partSize);
        long partStart = (long)part * this.partSize;
        long position = blockStart - partStart;
        long length = blockEnd - blockStart;
        BlobFetchRequest blobFetchRequest = BlobFetchRequest.builder().position(position).length(length).blobName(this.fileInfo.partName(part)).directory(this.directory).fileName(blockFileName).build();
        return this.transferManager.fetchBlob(blobFetchRequest);
    }

    @Override
    public OnDemandBlockSnapshotIndexInput clone() {
        OnDemandBlockSnapshotIndexInput clone = this.buildSlice("clone", 0L, this.length);
        clone.cloneBlock(this);
        return clone;
    }

    protected long getActualBlockSize(int blockId) {
        return blockId != this.getBlock(this.originalFileSize - 1L) ? (long)this.blockSize : (long)(this.getBlockOffset(this.originalFileSize - 1L) + 1);
    }
}

