/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.store.remote.lockmanager;

import io.skylite.core.index.store.remote.lockmanager.LockInfo;
import java.nio.file.NoSuchFileException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class FileLockInfo
implements LockInfo {
    private String fileToLock;
    private String acquirerId;
    private static final int INVALID_INDEX = -1;

    public String getAcquirerId() {
        return this.acquirerId;
    }

    public String getFileToLock() {
        return this.fileToLock;
    }

    private void setFileToLock(String fileName) {
        this.fileToLock = fileName;
    }

    private void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    @Override
    public String generateLockName() {
        FileLockInfo.validateRequiredParameters(this);
        return LockFileUtils.generateLockName(this.fileToLock, this.acquirerId);
    }

    String getLockPrefix() {
        if (this.fileToLock == null || this.fileToLock.isBlank()) {
            throw new IllegalArgumentException("File to Lock should be provided");
        }
        return this.fileToLock + "...";
    }

    String getLockForAcquirer(String[] lockFiles) throws NoSuchFileException {
        if (this.acquirerId == null || this.acquirerId.isBlank()) {
            throw new IllegalArgumentException("Acquirer ID should be provided");
        }
        List locksForAcquirer = Arrays.stream(lockFiles).filter(lockFile -> this.acquirerId.equals(LockFileUtils.getAcquirerIdFromLock(lockFile))).collect(Collectors.toList());
        if (locksForAcquirer.isEmpty()) {
            throw new NoSuchFileException("No lock file found for the acquirer: " + this.acquirerId);
        }
        if (locksForAcquirer.size() != 1) {
            throw new IllegalStateException("Expected single lock file but found [" + locksForAcquirer.size() + "] lock files");
        }
        return (String)locksForAcquirer.get(0);
    }

    public static LockInfoBuilder getLockInfoBuilder() {
        return new LockInfoBuilder();
    }

    private static void validateRequiredParameters(FileLockInfo fileLockInfo) {
        if (fileLockInfo.getAcquirerId() == null || fileLockInfo.getAcquirerId().isBlank()) {
            throw new IllegalArgumentException("Acquirer ID should be provided");
        }
        if (fileLockInfo.getFileToLock() == null || fileLockInfo.getFileToLock().isBlank()) {
            throw new IllegalArgumentException("File to Lock should be provided");
        }
    }

    static class LockFileUtils {
        LockFileUtils() {
        }

        static String generateLockName(String fileToLock, String acquirerId) {
            return String.join((CharSequence)"...", fileToLock, acquirerId) + ".v2_lock";
        }

        public static String getFileToLockNameFromLock(String lockName) {
            String lockSeparator = lockName.endsWith(".lock") ? "___" : "...";
            int indexOfSeparator = lockName.lastIndexOf(lockSeparator);
            if (indexOfSeparator == -1) {
                throw new IllegalArgumentException("Provided lock name: " + lockName + " is invalid with separator: " + lockSeparator);
            }
            return lockName.substring(0, indexOfSeparator);
        }

        public static String getAcquirerIdFromLock(String lockName) {
            String lockExtension = ".v2_lock";
            String lockSeparator = "...";
            if (lockName.endsWith(".lock")) {
                lockSeparator = "___";
                lockExtension = ".lock";
            }
            int indexOfSeparator = lockName.lastIndexOf(lockSeparator);
            int indexOfExt = lockName.lastIndexOf(lockExtension);
            if (indexOfSeparator == -1 || indexOfExt == -1) {
                throw new IllegalArgumentException("Provided lock name: " + lockName + " is invalid with separator: " + lockSeparator + " and extension: " + lockExtension);
            }
            return lockName.substring(indexOfSeparator + lockSeparator.length(), indexOfExt);
        }
    }

    public static class LockInfoBuilder
    implements LockInfo.LockInfoBuilder {
        private final FileLockInfo lockFileInfo = new FileLockInfo();

        LockInfoBuilder() {
        }

        public LockInfoBuilder withFileToLock(String fileToLock) {
            this.lockFileInfo.setFileToLock(fileToLock);
            return this;
        }

        public LockInfoBuilder withAcquirerId(String acquirerId) {
            this.lockFileInfo.setAcquirerId(acquirerId);
            return this;
        }

        @Override
        public FileLockInfo build() {
            if (this.lockFileInfo.fileToLock == null && this.lockFileInfo.acquirerId == null) {
                throw new IllegalStateException("Either File to Lock or AcquirerId should be provided to instantiate FileLockInfo");
            }
            return this.lockFileInfo;
        }
    }
}

