/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.storedfieldloader;

import io.skylite.core.index.storedfieldloader.StoredFieldsLoader;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.StoredFieldVisitor;

public class CustomStoredFieldsLoader
extends StoredFieldsLoader {
    private final Set<String> fields;

    public CustomStoredFieldsLoader(Set<String> fields, boolean loadSource) {
        super(loadSource);
        this.fields = fields;
    }

    @Override
    public Set<String> getFieldNames() {
        HashSet<String> fields = new HashSet<String>(super.getFieldNames());
        fields.addAll(this.fields);
        return fields;
    }

    @Override
    public StoredFieldVisitor.Status needsField(FieldInfo fieldInfo) {
        if (this.fields.isEmpty()) {
            return super.needsField(fieldInfo);
        }
        if (super.needsField(fieldInfo) == StoredFieldVisitor.Status.YES) {
            return StoredFieldVisitor.Status.YES;
        }
        if (this.fields.contains(fieldInfo.name)) {
            return StoredFieldVisitor.Status.YES;
        }
        return StoredFieldVisitor.Status.NO;
    }
}

