/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.io.stream.Writeable;
import io.skylite.core.common.unit.ByteSizeValue;
import io.skylite.core.index.remote.RemoteTranslogTransferTracker;
import io.skylite.core.xcontent.ToXContent;
import io.skylite.core.xcontent.ToXContentFragment;
import io.skylite.core.xcontent.XContentBuilder;
import java.io.IOException;
import java.util.Objects;

public class RemoteTranslogStats
implements ToXContentFragment,
Writeable {
    private long totalUploadsStarted;
    private long totalUploadsFailed;
    private long totalUploadsSucceeded;
    private long uploadBytesStarted;
    private long uploadBytesFailed;
    private long uploadBytesSucceeded;
    static final String REMOTE_STORE = "remote_store";

    public RemoteTranslogStats() {
    }

    public RemoteTranslogStats(StreamInput in) throws IOException {
        this.totalUploadsStarted = in.readVLong();
        this.totalUploadsFailed = in.readVLong();
        this.totalUploadsSucceeded = in.readVLong();
        this.uploadBytesStarted = in.readVLong();
        this.uploadBytesFailed = in.readVLong();
        this.uploadBytesSucceeded = in.readVLong();
    }

    public RemoteTranslogStats(RemoteTranslogTransferTracker.Stats transferTrackerStats) {
        this.totalUploadsStarted = transferTrackerStats.totalUploadsStarted;
        this.totalUploadsFailed = transferTrackerStats.totalUploadsFailed;
        this.totalUploadsSucceeded = transferTrackerStats.totalUploadsSucceeded;
        this.uploadBytesStarted = transferTrackerStats.uploadBytesStarted;
        this.uploadBytesFailed = transferTrackerStats.uploadBytesFailed;
        this.uploadBytesSucceeded = transferTrackerStats.uploadBytesSucceeded;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.totalUploadsStarted);
        out.writeVLong(this.totalUploadsFailed);
        out.writeVLong(this.totalUploadsSucceeded);
        out.writeVLong(this.uploadBytesStarted);
        out.writeVLong(this.uploadBytesFailed);
        out.writeVLong(this.uploadBytesSucceeded);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteTranslogStats other = (RemoteTranslogStats)obj;
        return this.totalUploadsStarted == other.totalUploadsStarted && this.totalUploadsFailed == other.totalUploadsFailed && this.totalUploadsSucceeded == other.totalUploadsSucceeded && this.uploadBytesStarted == other.uploadBytesStarted && this.uploadBytesFailed == other.uploadBytesFailed && this.uploadBytesSucceeded == other.uploadBytesSucceeded;
    }

    public int hashCode() {
        return Objects.hash(this.totalUploadsStarted, this.totalUploadsFailed, this.totalUploadsSucceeded, this.uploadBytesStarted, this.uploadBytesFailed, this.uploadBytesSucceeded);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(REMOTE_STORE);
        builder.startObject("upload");
        this.addRemoteTranslogUploadStatsXContent(builder);
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public long getTotalUploadsStarted() {
        return this.totalUploadsStarted;
    }

    public long getTotalUploadsFailed() {
        return this.totalUploadsFailed;
    }

    public long getTotalUploadsSucceeded() {
        return this.totalUploadsSucceeded;
    }

    public long getUploadBytesStarted() {
        return this.uploadBytesStarted;
    }

    public long getUploadBytesFailed() {
        return this.uploadBytesFailed;
    }

    public long getUploadBytesSucceeded() {
        return this.uploadBytesSucceeded;
    }

    public void add(RemoteTranslogStats other) {
        if (other == null) {
            return;
        }
        this.totalUploadsStarted += other.totalUploadsStarted;
        this.totalUploadsFailed += other.totalUploadsFailed;
        this.totalUploadsSucceeded += other.totalUploadsSucceeded;
        this.uploadBytesStarted += other.uploadBytesStarted;
        this.uploadBytesFailed += other.uploadBytesFailed;
        this.uploadBytesSucceeded += other.uploadBytesSucceeded;
    }

    void addRemoteTranslogUploadStatsXContent(XContentBuilder builder) throws IOException {
        builder.startObject("total_uploads");
        builder.field("started", this.totalUploadsStarted).field("failed", this.totalUploadsFailed).field("succeeded", this.totalUploadsSucceeded);
        builder.endObject();
        builder.startObject("total_upload_size");
        builder.humanReadableField("started_bytes", "started", new ByteSizeValue(this.uploadBytesStarted));
        builder.humanReadableField("failed_bytes", "failed", new ByteSizeValue(this.uploadBytesFailed));
        builder.humanReadableField("succeeded_bytes", "succeeded", new ByteSizeValue(this.uploadBytesSucceeded));
        builder.endObject();
    }
}

