/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.common.ExceptionsHelper;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.store.AlreadyClosedException;

public class TragicExceptionHolder {
    private final AtomicReference<Exception> tragedy = new AtomicReference();

    public void setTragicException(Exception ex) {
        assert (ex != null);
        if (this.tragedy.compareAndSet(null, ex)) {
            return;
        }
        Exception tragedy = this.tragedy.get();
        if (ExceptionsHelper.unwrapCausesAndSuppressed((Throwable)ex, e -> e == tragedy).isPresent()) {
            assert (ex == tragedy || ex instanceof AlreadyClosedException) : new AssertionError("must be ACE or tragic exception", ex);
        } else {
            tragedy.addSuppressed(ex);
        }
    }

    public Exception get() {
        return this.tragedy.get();
    }
}

