/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.common.Nullable;
import io.skylite.common.UUIDs;
import io.skylite.common.concurrent.ReleasableLock;
import io.skylite.common.io.FileChannelFactory;
import io.skylite.common.lease.Releasable;
import io.skylite.common.lease.Releasables;
import io.skylite.common.util.io.IOUtils;
import io.skylite.core.common.Strings;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.BufferedChecksumStreamInput;
import io.skylite.core.common.io.stream.BufferedChecksumStreamOutput;
import io.skylite.core.common.io.stream.ReleasableBytesStreamOutput;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.common.util.BigArrays;
import io.skylite.core.index.engine.MissingHistoryOperationsException;
import io.skylite.core.index.shard.AbstractIndexShardComponent;
import io.skylite.core.index.shard.IndexShardComponent;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.translog.BaseTranslogReader;
import io.skylite.core.index.translog.Checkpoint;
import io.skylite.core.index.translog.MultiSnapshot;
import io.skylite.core.index.translog.TragicExceptionHolder;
import io.skylite.core.index.translog.TranslogConfig;
import io.skylite.core.index.translog.TranslogCorruptedException;
import io.skylite.core.index.translog.TranslogDeletionPolicy;
import io.skylite.core.index.translog.TranslogException;
import io.skylite.core.index.translog.TranslogHeader;
import io.skylite.core.index.translog.TranslogLocation;
import io.skylite.core.index.translog.TranslogOperation;
import io.skylite.core.index.translog.TranslogReader;
import io.skylite.core.index.translog.TranslogSettings;
import io.skylite.core.index.translog.TranslogSnapshot;
import io.skylite.core.index.translog.TranslogSnapshotIterator;
import io.skylite.core.index.translog.TranslogStatelessHelper;
import io.skylite.core.index.translog.TranslogStats;
import io.skylite.core.index.translog.TranslogWriter;
import io.skylite.core.index.translog.TruncatedTranslogException;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongConsumer;
import java.util.function.LongSupplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;

public abstract class Translog
extends AbstractIndexShardComponent
implements IndexShardComponent,
Closeable {
    static final Pattern PARSE_STRICT_ID_PATTERN = Pattern.compile("^translog-(\\d+)(\\.tlog)$");
    protected final List<TranslogReader> readers = new ArrayList<TranslogReader>();
    protected final BigArrays bigArrays;
    protected final ReleasableLock readLock;
    protected final ReleasableLock writeLock;
    protected final Path location;
    protected TranslogWriter current;
    protected final TragicExceptionHolder tragedy = new TragicExceptionHolder();
    protected final AtomicBoolean closed = new AtomicBoolean();
    protected final TranslogConfig config;
    protected final LongSupplier globalCheckpointSupplier;
    protected final LongSupplier primaryTermSupplier;
    protected final String translogUUID;
    protected final TranslogDeletionPolicy deletionPolicy;
    protected final LongConsumer persistedSequenceNumberConsumer;

    public Translog(TranslogConfig config, String translogUUID, TranslogDeletionPolicy deletionPolicy, LongSupplier globalCheckpointSupplier, LongSupplier primaryTermSupplier, LongConsumer persistedSequenceNumberConsumer) throws IOException {
        super(config.getShardId(), config.getIndexSettings());
        this.config = config;
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.primaryTermSupplier = primaryTermSupplier;
        this.persistedSequenceNumberConsumer = persistedSequenceNumberConsumer;
        this.deletionPolicy = deletionPolicy;
        this.translogUUID = translogUUID;
        this.bigArrays = config.getBigArrays();
        ReentrantReadWriteLock rwl = new ReentrantReadWriteLock();
        this.readLock = new ReleasableLock(rwl.readLock());
        this.writeLock = new ReleasableLock(rwl.writeLock());
        this.location = config.getTranslogPath();
        Files.createDirectories(this.location, new FileAttribute[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<TranslogReader> recoverFromFiles(Checkpoint checkpoint) throws IOException {
        boolean success = false;
        ArrayList<TranslogReader> foundTranslogs = new ArrayList<TranslogReader>();
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.logger.debug("open uncommitted translog checkpoint {}", (Object)checkpoint);
            long minGenerationToRecoverFrom = checkpoint.minTranslogGeneration;
            for (long i = checkpoint.generation; i >= minGenerationToRecoverFrom; --i) {
                Path committedTranslogFile = this.location.resolve(TranslogStatelessHelper.getFilename(i));
                if (!Files.exists(committedTranslogFile, new LinkOption[0])) {
                    throw new TranslogCorruptedException(committedTranslogFile.toString(), "translog file doesn't exist with generation: " + i + " recovering from: " + minGenerationToRecoverFrom + " checkpoint: " + checkpoint.generation + " - translog ids must be consecutive");
                }
                Checkpoint readerCheckpoint = i == checkpoint.generation ? checkpoint : Checkpoint.read(this.location.resolve(Translog.getCommitCheckpointFileName(i)));
                TranslogReader reader = this.openReader(committedTranslogFile, readerCheckpoint);
                assert (reader.getPrimaryTerm() <= this.primaryTermSupplier.getAsLong()) : "Primary terms go backwards; current term [" + this.primaryTermSupplier.getAsLong() + "] translog path [ " + String.valueOf(committedTranslogFile) + ", existing term [" + reader.getPrimaryTerm() + "]";
                foundTranslogs.add(reader);
                this.logger.debug("recovered local translog from checkpoint {}", (Object)checkpoint);
            }
            Collections.reverse(foundTranslogs);
            IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{this.location.resolve(TranslogStatelessHelper.getFilename(minGenerationToRecoverFrom - 1L)), this.location.resolve(Translog.getCommitCheckpointFileName(minGenerationToRecoverFrom - 1L))});
            Path commitCheckpoint = this.location.resolve(Translog.getCommitCheckpointFileName(checkpoint.generation));
            if (Files.exists(commitCheckpoint, new LinkOption[0])) {
                Checkpoint checkpointFromDisk = Checkpoint.read(commitCheckpoint);
                if (!checkpoint.equals(checkpointFromDisk)) {
                    throw new TranslogCorruptedException(commitCheckpoint.toString(), "checkpoint file " + String.valueOf(commitCheckpoint.getFileName()) + " already exists but has corrupted content: expected " + String.valueOf(checkpoint) + " but got " + String.valueOf(checkpointFromDisk));
                }
            } else {
                this.copyCheckpointTo(commitCheckpoint);
            }
            success = true;
        }
        finally {
            if (!success) {
                IOUtils.closeWhileHandlingException(foundTranslogs);
            }
        }
        return foundTranslogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyCheckpointTo(Path targetPath) throws IOException {
        Path tempFile = Files.createTempFile(this.location, "translog-", ".ckp", new FileAttribute[0]);
        boolean tempFileRenamed = false;
        try {
            Files.copy(this.location.resolve("translog.ckp"), tempFile, StandardCopyOption.REPLACE_EXISTING);
            IOUtils.fsync((Path)tempFile, (boolean)false);
            Files.move(tempFile, targetPath, StandardCopyOption.ATOMIC_MOVE);
            tempFileRenamed = true;
            IOUtils.fsync((Path)targetPath.getParent(), (boolean)true);
        }
        finally {
            if (!tempFileRenamed) {
                try {
                    Files.delete(tempFile);
                }
                catch (IOException ex) {
                    this.logger.warn(() -> new ParameterizedMessage("failed to delete temp file {}", (Object)tempFile), (Throwable)ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TranslogReader openReader(Path path, Checkpoint checkpoint) throws IOException {
        FileChannel channel = FileChannel.open(path, StandardOpenOption.READ);
        try {
            assert (Translog.parseIdFromFileName(path) == checkpoint.generation) : "expected generation: " + Translog.parseIdFromFileName(path) + " but got: " + checkpoint.generation;
            TranslogReader reader = TranslogReader.open(channel, path, checkpoint, this.translogUUID);
            channel = null;
            TranslogReader translogReader = reader;
            return translogReader;
        }
        finally {
            IOUtils.close((Closeable)channel);
        }
    }

    public static long parseIdFromFileName(Path translogFile) {
        String fileName = translogFile.getFileName().toString();
        Matcher matcher = PARSE_STRICT_ID_PATTERN.matcher(fileName);
        if (matcher.matches()) {
            try {
                return Long.parseLong(matcher.group(1));
            }
            catch (NumberFormatException e) {
                throw new IllegalStateException("number formatting issue in a file that passed PARSE_STRICT_ID_PATTERN: " + fileName + "]", e);
            }
        }
        throw new IllegalArgumentException("can't parse id from file: " + fileName);
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    protected static boolean calledFromOutsideOrViaTragedyClose() {
        List frames = Stream.of(Thread.currentThread().getStackTrace()).skip(3L).limit(10L).filter(f -> {
            try {
                return Translog.class.isAssignableFrom(Class.forName(f.getClassName()));
            }
            catch (Exception ignored) {
                return false;
            }
        }).collect(Collectors.toList());
        return frames.isEmpty() || frames.stream().anyMatch(f -> f.getMethodName().equals("closeOnTragicEvent"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        assert (Translog.calledFromOutsideOrViaTragedyClose()) : "Translog.close method is called from inside Translog, but not via closeOnTragicEvent method";
        if (this.closed.compareAndSet(false, true)) {
            try (ReleasableLock lock = this.writeLock.acquire();){
                try {
                    this.current.sync();
                }
                finally {
                    this.closeFilesIfNoPendingRetentionLocks();
                }
            }
            finally {
                this.logger.debug("translog closed");
            }
        }
    }

    public Path location() {
        return this.location;
    }

    public long currentFileGeneration() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            long l = this.current.getGeneration();
            return l;
        }
    }

    public long getMinFileGeneration() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            if (this.readers.isEmpty()) {
                long l = this.current.getGeneration();
                return l;
            }
            assert (this.readers.stream().map(BaseTranslogReader::getGeneration).min(Long::compareTo).get().equals(this.readers.get(0).getGeneration())) : "the first translog isn't the one with the minimum generation:" + String.valueOf(this.readers);
            long l = this.readers.get(0).getGeneration();
            return l;
        }
    }

    public int totalOperations() {
        return this.totalOperationsByMinGen(-1L);
    }

    public long sizeInBytes() {
        return this.sizeInBytesByMinGen(-1L);
    }

    long earliestLastModifiedAge() {
        long l;
        block8: {
            ReleasableLock ignored = this.readLock.acquire();
            try {
                this.ensureOpen();
                l = Translog.findEarliestLastModifiedAge(System.currentTimeMillis(), this.readers, this.current);
                if (ignored == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (ignored != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new TranslogException(this.shardId, "Unable to get the earliest last modified time for the transaction log");
                }
            }
            ignored.close();
        }
        return l;
    }

    static long findEarliestLastModifiedAge(long currentTime, Iterable<TranslogReader> readers, TranslogWriter writer) throws IOException {
        long earliestTime = currentTime;
        for (BaseTranslogReader baseTranslogReader : readers) {
            earliestTime = Math.min(baseTranslogReader.getLastModifiedTime(), earliestTime);
        }
        return Math.max(0L, currentTime - Math.min(earliestTime, writer.getLastModifiedTime()));
    }

    public int totalOperationsByMinGen(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            int n = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToInt(rec$ -> ((BaseTranslogReader)rec$).totalOperations()).sum();
            return n;
        }
    }

    public int estimateTotalOperationsFromMinSeq(long minSeqNo) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            int n = this.readersAboveMinSeqNo(minSeqNo).mapToInt(BaseTranslogReader::totalOperations).sum();
            return n;
        }
    }

    public long sizeInBytesByMinGen(long minGeneration) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            long l = Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(r -> r.getGeneration() >= minGeneration).mapToLong(rec$ -> ((BaseTranslogReader)rec$).sizeInBytes()).sum();
            return l;
        }
    }

    public TranslogWriter createWriter(long fileGeneration) throws IOException {
        TranslogWriter writer = this.createWriter(fileGeneration, this.getMinFileGeneration(), this.globalCheckpointSupplier.getAsLong(), this.persistedSequenceNumberConsumer);
        assert (writer.sizeInBytes() == (long)TranslogSettings.DEFAULT_HEADER_SIZE_IN_BYTES) : "Mismatch translog header size; empty translog size [" + writer.sizeInBytes() + ", header size [" + TranslogSettings.DEFAULT_HEADER_SIZE_IN_BYTES + "]";
        return writer;
    }

    public TranslogWriter createWriter(long fileGeneration, long initialMinTranslogGen, long initialGlobalCheckpoint, LongConsumer persistedSequenceNumberConsumer) throws IOException {
        TranslogWriter newWriter;
        try {
            newWriter = TranslogWriter.create(this.shardId, this.translogUUID, fileGeneration, this.location.resolve(TranslogStatelessHelper.getFilename(fileGeneration)), this.getChannelFactory(), this.config.getBufferSize(), initialMinTranslogGen, initialGlobalCheckpoint, this.globalCheckpointSupplier, this::getMinFileGeneration, this.primaryTermSupplier.getAsLong(), this.tragedy, persistedSequenceNumberConsumer, this.bigArrays, this.indexSettings.isAssignedOnRemoteNode());
        }
        catch (IOException e) {
            throw new TranslogException(this.shardId, "failed to create new translog file", e);
        }
        return newWriter;
    }

    public TranslogLocation add(TranslogOperation operation) throws IOException {
        ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(this.bigArrays);
        try {
            TranslogLocation translogLocation;
            block14: {
                long start = out.position();
                out.skip(4);
                Translog.writeOperationNoSize(new BufferedChecksumStreamOutput(out), operation);
                long end = out.position();
                int operationSize = (int)(end - 4L - start);
                out.seek(start);
                out.writeInt(operationSize);
                out.seek(end);
                BytesReference bytes = out.bytes();
                ReleasableLock ignored = this.readLock.acquire();
                try {
                    this.ensureOpen();
                    if (operation.primaryTerm() > this.current.getPrimaryTerm()) {
                        assert (false) : "Operation term is newer than the current term; current term[" + this.current.getPrimaryTerm() + "], operation term[" + String.valueOf(operation) + "]";
                        throw new IllegalArgumentException("Operation term is newer than the current term; current term[" + this.current.getPrimaryTerm() + "], operation term[" + String.valueOf(operation) + "]");
                    }
                    translogLocation = this.current.add(bytes, operation.seqNo());
                    if (ignored == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | AlreadyClosedException ex) {
                        this.closeOnTragicEvent((Exception)ex);
                        throw ex;
                    }
                    catch (Exception ex) {
                        this.closeOnTragicEvent(ex);
                        throw new TranslogException(this.shardId, "Failed to write operation [" + String.valueOf(operation) + "]", ex);
                    }
                }
                ignored.close();
            }
            return translogLocation;
        }
        finally {
            Releasables.close((Releasable)out);
        }
    }

    public boolean shouldRollGeneration() {
        long threshold = this.indexSettings.getGenerationThresholdSize().getBytes();
        try (ReleasableLock ignored = this.readLock.acquire();){
            boolean bl = this.current.sizeInBytes() > threshold;
            return bl;
        }
    }

    public TranslogLocation getLastWriteLocation() {
        try (ReleasableLock lock = this.readLock.acquire();){
            TranslogLocation translogLocation = new TranslogLocation(this.current.generation, this.current.sizeInBytes() - 1L, Integer.MAX_VALUE);
            return translogLocation;
        }
    }

    public long getLastSyncedGlobalCheckpoint() {
        return this.getLastSyncedCheckpoint().globalCheckpoint;
    }

    final Checkpoint getLastSyncedCheckpoint() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            Checkpoint checkpoint = this.current.getLastSyncedCheckpoint();
            return checkpoint;
        }
    }

    public TranslogSnapshotIterator newSnapshot() throws IOException {
        return this.newSnapshot(0L, Long.MAX_VALUE);
    }

    public TranslogSnapshotIterator newSnapshot(long fromSeqNo, long toSeqNo) throws IOException {
        return this.newSnapshot(fromSeqNo, toSeqNo, false);
    }

    public TranslogSnapshotIterator newSnapshot(long fromSeqNo, long toSeqNo, boolean requiredFullRange) throws IOException {
        assert (fromSeqNo <= toSeqNo) : fromSeqNo + " > " + toSeqNo;
        assert (fromSeqNo >= 0L) : "from_seq_no must be non-negative " + fromSeqNo;
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            TranslogSnapshot[] snapshots = (TranslogSnapshot[])Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(reader -> reader.getCheckpoint().minSeqNo <= toSeqNo && fromSeqNo <= reader.getCheckpoint().maxEffectiveSeqNo()).map(rec$ -> ((BaseTranslogReader)rec$).newSnapshot()).toArray(TranslogSnapshot[]::new);
            TranslogSnapshotIterator snapshot = this.newMultiSnapshot(snapshots);
            SeqNoFilterSnapshot seqNoFilterSnapshot = new SeqNoFilterSnapshot(snapshot, fromSeqNo, toSeqNo, requiredFullRange);
            return seqNoFilterSnapshot;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TranslogOperation readOperation(TranslogLocation location) throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            if (location.generation < this.getMinFileGeneration()) {
                TranslogOperation translogOperation = null;
                return translogOperation;
            }
            if (this.current.generation == location.generation) {
                TranslogOperation translogOperation = this.current.read(location);
                return translogOperation;
            }
            int i = this.readers.size() - 1;
            while (i >= 0) {
                TranslogReader translogReader = this.readers.get(i);
                if (translogReader.generation == location.generation) {
                    TranslogOperation translogOperation = translogReader.read(location);
                    return translogOperation;
                }
                --i;
            }
            return null;
        }
        catch (Exception ex) {
            this.closeOnTragicEvent(ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslogSnapshotIterator newMultiSnapshot(TranslogSnapshot[] snapshots) throws IOException {
        Closeable onClose;
        if (snapshots.length == 0) {
            onClose = () -> {};
        } else {
            assert (Arrays.stream(snapshots).map(BaseTranslogReader::getGeneration).min(Long::compareTo).get() == snapshots[0].generation) : "first reader generation of " + String.valueOf(snapshots) + " is not the smallest";
            onClose = this.acquireTranslogGenFromDeletionPolicy(snapshots[0].generation);
        }
        boolean success = false;
        try {
            MultiSnapshot result = new MultiSnapshot(snapshots, onClose);
            success = true;
            MultiSnapshot multiSnapshot = result;
            return multiSnapshot;
        }
        finally {
            if (!success) {
                onClose.close();
            }
        }
    }

    private Stream<? extends BaseTranslogReader> readersAboveMinSeqNo(long minSeqNo) {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread()) : "callers of readersAboveMinSeqNo must hold a lock: readLock [" + this.readLock.isHeldByCurrentThread() + "], writeLock [" + this.readLock.isHeldByCurrentThread() + "]";
        return Stream.concat(this.readers.stream(), Stream.of(this.current)).filter(reader -> minSeqNo <= reader.getCheckpoint().maxEffectiveSeqNo());
    }

    public Closeable acquireRetentionLock() {
        try (ReleasableLock lock = this.readLock.acquire();){
            this.ensureOpen();
            long viewGen = this.getMinFileGeneration();
            Closeable closeable = this.acquireTranslogGenFromDeletionPolicy(viewGen);
            return closeable;
        }
    }

    private Closeable acquireTranslogGenFromDeletionPolicy(long viewGen) {
        Releasable toClose = this.deletionPolicy.acquireTranslogGen(viewGen);
        return () -> {
            try {
                toClose.close();
            }
            finally {
                this.trimUnreferencedReaders();
                this.closeFilesIfNoPendingRetentionLocks();
            }
        };
    }

    public void sync() throws IOException {
        try (ReleasableLock lock = this.readLock.acquire();){
            if (!this.closed.get()) {
                this.current.sync();
            }
        }
        catch (Exception ex) {
            this.closeOnTragicEvent(ex);
            throw ex;
        }
    }

    public boolean syncNeeded() {
        try (ReleasableLock lock = this.readLock.acquire();){
            boolean bl = this.current.syncNeeded();
            return bl;
        }
    }

    public static String getCommitCheckpointFileName(long generation) {
        return "translog-" + generation + ".ckp";
    }

    public void trimOperations(long belowTerm, long aboveSeqNo) throws IOException {
        assert (aboveSeqNo >= -1L) : "aboveSeqNo has to a valid sequence number";
        try (ReleasableLock lock = this.writeLock.acquire();){
            this.ensureOpen();
            if (this.current.getPrimaryTerm() < belowTerm) {
                throw new IllegalArgumentException("Trimming the translog can only be done for terms lower than the current one. Trim requested for term [ " + belowTerm + " ] , current is [ " + this.current.getPrimaryTerm() + " ]");
            }
            assert (this.current.assertNoSeqAbove(belowTerm, aboveSeqNo));
            ArrayList<TranslogReader> newReaders = new ArrayList<TranslogReader>(this.readers.size());
            try {
                for (TranslogReader reader : this.readers) {
                    TranslogReader newReader = reader.getPrimaryTerm() < belowTerm ? reader.closeIntoTrimmedReader(aboveSeqNo, this.getChannelFactory()) : reader;
                    newReaders.add(newReader);
                }
            }
            catch (IOException e) {
                IOUtils.closeWhileHandlingException(newReaders);
                this.tragedy.setTragicException(e);
                this.closeOnTragicEvent(e);
                throw e;
            }
            this.readers.clear();
            this.readers.addAll(newReaders);
        }
    }

    public abstract boolean ensureSynced(TranslogLocation var1) throws IOException;

    public boolean ensureSynced(Stream<TranslogLocation> locations) throws IOException {
        Optional<TranslogLocation> max = locations.max(TranslogLocation::compareTo);
        if (max.isPresent()) {
            return this.ensureSynced(max.get());
        }
        return false;
    }

    protected void closeOnTragicEvent(Exception ex) {
        assert (!this.readLock.isHeldByCurrentThread()) : Thread.currentThread().getName();
        if (this.tragedy.get() != null) {
            try {
                this.close();
            }
            catch (AlreadyClosedException alreadyClosedException) {
            }
            catch (Exception inner) {
                assert (ex != inner.getCause());
                ex.addSuppressed(inner);
            }
        }
    }

    public TranslogStats stats() {
        try (ReleasableLock lock = this.readLock.acquire();){
            long uncommittedGen = this.getMinGenerationForSeqNo((long)(this.deletionPolicy.getLocalCheckpointOfSafeCommit() + 1L)).translogFileGeneration;
            TranslogStats translogStats = new TranslogStats(this.totalOperations(), this.sizeInBytes(), this.totalOperationsByMinGen(uncommittedGen), this.sizeInBytesByMinGen(uncommittedGen), this.earliestLastModifiedAge());
            return translogStats;
        }
    }

    public TranslogConfig getConfig() {
        return this.config;
    }

    public TranslogDeletionPolicy getDeletionPolicy() {
        return this.deletionPolicy;
    }

    public static List<TranslogOperation> readOperations(StreamInput input, String source) throws IOException {
        ArrayList<TranslogOperation> operations = new ArrayList<TranslogOperation>();
        int numOps = input.readInt();
        BufferedChecksumStreamInput checksumStreamInput = new BufferedChecksumStreamInput(input, source);
        for (int i = 0; i < numOps; ++i) {
            operations.add(Translog.readOperation(checksumStreamInput));
        }
        return operations;
    }

    static TranslogOperation readOperation(BufferedChecksumStreamInput in) throws IOException {
        TranslogOperation operation;
        try {
            int opSize = in.readInt();
            if (opSize < 4) {
                throw new TranslogCorruptedException(in.getSource(), "operation size must be at least 4 but was: " + opSize);
            }
            in.resetDigest();
            if (in.markSupported()) {
                in.mark(opSize);
                in.skip(opSize - 4);
                BufferedChecksumStreamInput.verifyChecksum(in);
                in.reset();
            }
            operation = TranslogOperation.readOperation(in);
            BufferedChecksumStreamInput.verifyChecksum(in);
        }
        catch (EOFException e) {
            throw new TruncatedTranslogException(in.getSource(), "reached premature end of file, translog is truncated", e);
        }
        return operation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeOperations(StreamOutput outStream, List<TranslogOperation> toWrite) throws IOException {
        ReleasableBytesStreamOutput out = new ReleasableBytesStreamOutput(BigArrays.NON_RECYCLING_INSTANCE);
        try {
            outStream.writeInt(toWrite.size());
            BufferedChecksumStreamOutput checksumStreamOutput = new BufferedChecksumStreamOutput(out);
            for (TranslogOperation op : toWrite) {
                out.reset();
                long start = out.position();
                out.skip(4);
                Translog.writeOperationNoSize(checksumStreamOutput, op);
                long end = out.position();
                int operationSize = (int)(out.position() - 4L - start);
                out.seek(start);
                out.writeInt(operationSize);
                out.seek(end);
                out.bytes().writeTo(outStream);
            }
        }
        finally {
            Releasables.close((Releasable)out);
        }
    }

    public static void writeOperationNoSize(BufferedChecksumStreamOutput out, TranslogOperation op) throws IOException {
        out.resetDigest();
        TranslogOperation.writeOperation(out, op);
        long checksum = out.getChecksum();
        out.writeInt((int)checksum);
    }

    public TranslogGeneration getMinGenerationForSeqNo(long seqNo) {
        try (ReleasableLock ignored = this.readLock.acquire();){
            TranslogGeneration translogGeneration = new TranslogGeneration(this.translogUUID, Translog.minGenerationForSeqNo(seqNo, this.current, this.readers));
            return translogGeneration;
        }
    }

    public static long minGenerationForSeqNo(long seqNo, TranslogWriter writer, List<TranslogReader> readers) {
        long minGen = writer.generation;
        for (TranslogReader reader : readers) {
            if (seqNo > reader.getCheckpoint().maxEffectiveSeqNo()) continue;
            minGen = Math.min(minGen, reader.getGeneration());
        }
        return minGen;
    }

    public void rollGeneration() throws IOException {
        this.syncBeforeRollGeneration();
        if (this.current.totalOperations() == 0 && this.primaryTermSupplier.getAsLong() == this.current.getPrimaryTerm()) {
            return;
        }
        try (ReleasableLock ignored = this.writeLock.acquire();){
            this.ensureOpen();
            try {
                TranslogReader reader = this.current.closeIntoReader();
                this.readers.add(reader);
                assert (Checkpoint.read((Path)this.location.resolve((String)"translog.ckp")).generation == this.current.getGeneration());
                this.copyCheckpointTo(this.location.resolve(Translog.getCommitCheckpointFileName(this.current.getGeneration())));
                this.current = this.createWriter(this.current.getGeneration() + 1L);
                this.logger.trace("current translog set to [{}]", (Object)this.current.getGeneration());
            }
            catch (Exception e) {
                this.tragedy.setTragicException(e);
                this.closeOnTragicEvent(e);
                throw e;
            }
        }
    }

    public void syncBeforeRollGeneration() throws IOException {
        this.sync();
    }

    public void trimUnreferencedReaders() throws IOException {
        try (ReleasableLock ignored = this.readLock.acquire();){
            if (this.closed.get()) {
                return;
            }
            if (this.getMinReferencedGen() == this.getMinFileGeneration()) {
                return;
            }
        }
        this.sync();
        try {
            ignored = this.writeLock.acquire();
            try {
                TranslogReader reader;
                if (this.closed.get()) {
                    return;
                }
                long minReferencedGen = this.getMinReferencedGen();
                Iterator<TranslogReader> iterator = this.readers.iterator();
                while (iterator.hasNext() && (reader = iterator.next()).getGeneration() < minReferencedGen) {
                    iterator.remove();
                    IOUtils.closeWhileHandlingException((Closeable)reader);
                    Path translogPath = reader.path();
                    this.logger.trace("delete translog file [{}], not referenced and not current anymore", (Object)translogPath);
                    this.current.sync();
                    this.deleteReaderFiles(reader);
                }
                assert (!this.readers.isEmpty() || this.current.generation == minReferencedGen) : "all readers were cleaned but the minReferenceGen [" + minReferencedGen + "] is not the current writer's gen [" + this.current.generation + "]";
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }
        catch (Exception ex) {
            this.closeOnTragicEvent(ex);
            throw ex;
        }
    }

    protected long getMinReferencedGen() throws IOException {
        assert (this.readLock.isHeldByCurrentThread() || this.writeLock.isHeldByCurrentThread());
        long minReferencedGen = Math.min(this.deletionPolicy.minTranslogGenRequired(this.readers, this.current), Translog.minGenerationForSeqNo(this.deletionPolicy.getLocalCheckpointOfSafeCommit() + 1L, this.current, this.readers));
        assert (minReferencedGen >= this.getMinFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] but the lowest gen available is [" + this.getMinFileGeneration() + "]";
        assert (minReferencedGen <= this.currentFileGeneration()) : "deletion policy requires a minReferenceGen of [" + minReferencedGen + "] which is higher than the current generation [" + this.currentFileGeneration() + "]";
        return minReferencedGen;
    }

    protected void setMinSeqNoToKeep(long seqNo) {
    }

    protected void onDelete() {
    }

    protected abstract Releasable drainSync();

    void deleteReaderFiles(TranslogReader reader) {
        IOUtils.deleteFilesIgnoringExceptions((Path[])new Path[]{reader.path(), reader.path().resolveSibling(Translog.getCommitCheckpointFileName(reader.getGeneration()))});
    }

    public void closeFilesIfNoPendingRetentionLocks() throws IOException {
        try (ReleasableLock ignored = this.writeLock.acquire();){
            if (this.closed.get() && this.deletionPolicy.pendingTranslogRefCount() == 0) {
                this.logger.trace("closing files. translog is closed and there are no pending retention locks");
                ArrayList<TranslogReader> toClose = new ArrayList<TranslogReader>(this.readers);
                toClose.add((TranslogReader)((Object)this.current));
                IOUtils.close(toClose);
            }
        }
    }

    public TranslogGeneration getGeneration() {
        return new TranslogGeneration(this.translogUUID, this.currentFileGeneration());
    }

    long getFirstOperationPosition() {
        return this.current.getFirstOperationOffset();
    }

    protected void ensureOpen() {
        if (this.closed.get()) {
            throw new AlreadyClosedException("translog is already closed", (Throwable)this.tragedy.get());
        }
    }

    public FileChannelFactory getChannelFactory() {
        return FileChannel::open;
    }

    public Exception getTragicException() {
        return this.tragedy.get();
    }

    public String getTranslogUUID() {
        return this.translogUUID;
    }

    public long getMaxSeqNo() {
        try (ReleasableLock ignored = this.readLock.acquire();){
            this.ensureOpen();
            OptionalLong maxSeqNo = Stream.concat(this.readers.stream(), Stream.of(this.current)).mapToLong(reader -> reader.getCheckpoint().maxSeqNo).max();
            assert (maxSeqNo.isPresent()) : "must have at least one translog generation";
            long l = maxSeqNo.getAsLong();
            return l;
        }
    }

    TranslogWriter getCurrent() {
        return this.current;
    }

    List<TranslogReader> getReaders() {
        return this.readers;
    }

    public static String createEmptyTranslog(Path location, long initialGlobalCheckpoint, ShardId shardId, long primaryTerm) throws IOException {
        FileChannelFactory fileChannelFactory = FileChannel::open;
        return Translog.createEmptyTranslog(location, initialGlobalCheckpoint, shardId, fileChannelFactory, primaryTerm);
    }

    public static String createEmptyTranslog(Path location, long initialGlobalCheckpoint, ShardId shardId, FileChannelFactory fileChannelFactory, long primaryTerm) throws IOException {
        return Translog.createEmptyTranslog(location, shardId, initialGlobalCheckpoint, primaryTerm, null, fileChannelFactory);
    }

    public static String createEmptyTranslog(Path location, ShardId shardId, long initialGlobalCheckpoint, long primaryTerm, @Nullable String translogUUID, @Nullable FileChannelFactory factory) throws IOException {
        return Translog.createEmptyTranslog(location, shardId, initialGlobalCheckpoint, primaryTerm, translogUUID, factory, 1L);
    }

    public static String createEmptyTranslog(Path location, ShardId shardId, Checkpoint checkpoint) throws IOException {
        TranslogHeader translogHeader;
        Path highestGenTranslogFile = location.resolve(TranslogStatelessHelper.getFilename(checkpoint.generation));
        try (FileChannel channel = FileChannel.open(highestGenTranslogFile, StandardOpenOption.READ);){
            translogHeader = TranslogHeader.read(highestGenTranslogFile, channel);
        }
        String translogUUID = translogHeader.getTranslogUUID();
        long primaryTerm = translogHeader.getPrimaryTerm();
        FileChannelFactory channelFactory = FileChannel::open;
        return Translog.createEmptyTranslog(location, shardId, -1L, primaryTerm, translogUUID, channelFactory, checkpoint.generation + 1L);
    }

    public static String createEmptyTranslog(Path location, ShardId shardId, long initialGlobalCheckpoint, long primaryTerm, @Nullable String translogUUID, @Nullable FileChannelFactory factory, long generation) throws IOException {
        IOUtils.rm((Path[])new Path[]{location});
        Files.createDirectories(location, new FileAttribute[0]);
        FileChannelFactory fileChannelFactory = factory != null ? factory : FileChannel::open;
        String uuid = Strings.hasLength(translogUUID) ? translogUUID : UUIDs.randomBase64UUID();
        Path checkpointFile = location.resolve("translog.ckp");
        Path translogFile = location.resolve(TranslogStatelessHelper.getFilename(generation));
        Checkpoint checkpoint = TranslogStatelessHelper.emptyCheckpoint(0L, generation, initialGlobalCheckpoint, generation);
        Checkpoint.write(fileChannelFactory, checkpointFile, checkpoint, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);
        TranslogWriter writer = TranslogWriter.create(shardId, uuid, generation, translogFile, fileChannelFactory, TranslogConfig.EMPTY_TRANSLOG_BUFFER_SIZE, generation, initialGlobalCheckpoint, () -> {
            throw new UnsupportedOperationException();
        }, () -> {
            throw new UnsupportedOperationException();
        }, primaryTerm, new TragicExceptionHolder(), seqNo -> {
            throw new UnsupportedOperationException();
        }, BigArrays.NON_RECYCLING_INSTANCE, null);
        writer.close();
        return uuid;
    }

    public long getMinUnreferencedSeqNoInSegments(long minUnrefCheckpointInLastCommit) {
        return minUnrefCheckpointInLastCommit;
    }

    protected boolean shouldFlush() {
        return false;
    }

    private static final class SeqNoFilterSnapshot
    implements TranslogSnapshotIterator {
        private final TranslogSnapshotIterator delegate;
        private int filteredOpsCount;
        private int opsCount;
        private boolean requiredFullRange;
        private final long fromSeqNo;
        private final long toSeqNo;

        SeqNoFilterSnapshot(TranslogSnapshotIterator delegate, long fromSeqNo, long toSeqNo, boolean requiredFullRange) {
            assert (fromSeqNo <= toSeqNo) : "from_seq_no[" + fromSeqNo + "] > to_seq_no[" + toSeqNo + "]";
            this.delegate = delegate;
            this.fromSeqNo = fromSeqNo;
            this.toSeqNo = toSeqNo;
            this.requiredFullRange = requiredFullRange;
        }

        @Override
        public int totalOperations() {
            return this.delegate.totalOperations();
        }

        @Override
        public int skippedOperations() {
            return this.filteredOpsCount + this.delegate.skippedOperations();
        }

        @Override
        public TranslogOperation next() throws IOException, MissingHistoryOperationsException {
            TranslogOperation op;
            while ((op = this.delegate.next()) != null) {
                if (this.fromSeqNo <= op.seqNo() && op.seqNo() <= this.toSeqNo) {
                    ++this.opsCount;
                    return op;
                }
                ++this.filteredOpsCount;
            }
            if (this.requiredFullRange && this.toSeqNo - this.fromSeqNo + 1L != (long)this.opsCount) {
                throw new MissingHistoryOperationsException("Not all operations between from_seqno [" + this.fromSeqNo + "] and to_seqno [" + this.toSeqNo + "] found");
            }
            return null;
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }
    }

    public static final class TranslogGeneration {
        public final String translogUUID;
        public final long translogFileGeneration;

        public TranslogGeneration(String translogUUID, long translogFileGeneration) {
            this.translogUUID = translogUUID;
            this.translogFileGeneration = translogFileGeneration;
        }
    }
}

