/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

public class TranslogLocation
implements Comparable<TranslogLocation> {
    public final long generation;
    public final long translogLocation;
    public final int size;

    public TranslogLocation(long generation, long translogLocation, int size) {
        this.generation = generation;
        this.translogLocation = translogLocation;
        this.size = size;
    }

    public String toString() {
        return "[generation: " + this.generation + ", location: " + this.translogLocation + ", size: " + this.size + "]";
    }

    @Override
    public int compareTo(TranslogLocation o) {
        if (this.generation == o.generation) {
            return Long.compare(this.translogLocation, o.translogLocation);
        }
        return Long.compare(this.generation, o.generation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TranslogLocation location = (TranslogLocation)o;
        if (this.generation != location.generation) {
            return false;
        }
        if (this.translogLocation != location.translogLocation) {
            return false;
        }
        return this.size == location.size;
    }

    public int hashCode() {
        int result = Long.hashCode(this.generation);
        result = 31 * result + Long.hashCode(this.translogLocation);
        result = 31 * result + this.size;
        return result;
    }
}

