/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.translog;

import io.skylite.OpenSearchVersion;
import io.skylite.core.ParseField;
import io.skylite.core.common.bytes.BytesArray;
import io.skylite.core.common.bytes.BytesReference;
import io.skylite.core.common.io.stream.StreamInput;
import io.skylite.core.common.io.stream.StreamOutput;
import io.skylite.core.index.VersionType;
import io.skylite.core.index.engine.EngineOperation;
import io.skylite.core.index.engine.EngineResult;
import io.skylite.core.mapper.Uid;
import java.io.IOException;
import java.util.Objects;

public sealed interface TranslogOperation {
    public Type opType();

    public long estimateSize();

    public Source getSource();

    public long seqNo();

    public long primaryTerm();

    public static TranslogOperation readOperation(StreamInput input) throws IOException {
        Type type = Type.fromId(input.readByte());
        switch (type.ordinal()) {
            case 0: 
            case 1: {
                return new Index(input);
            }
            case 2: {
                return new Delete(input);
            }
            case 3: {
                return new NoOp(input);
            }
        }
        throw new AssertionError((Object)("no case for [" + String.valueOf((Object)type) + "]"));
    }

    public static void writeOperation(StreamOutput output, TranslogOperation operation) throws IOException {
        output.writeByte(operation.opType().id());
        switch (operation.opType().ordinal()) {
            case 0: 
            case 1: {
                ((Index)operation).write(output);
                break;
            }
            case 2: {
                ((Delete)operation).write(output);
                break;
            }
            case 3: {
                ((NoOp)operation).write(output);
                break;
            }
            default: {
                throw new AssertionError((Object)("no case for [" + String.valueOf((Object)operation.opType()) + "]"));
            }
        }
    }

    public static enum Type {
        CREATE(1),
        INDEX(2),
        DELETE(3),
        NO_OP(4);

        private final byte id;

        private Type(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Type fromId(byte id) {
            switch (id) {
                case 1: {
                    return CREATE;
                }
                case 2: {
                    return INDEX;
                }
                case 3: {
                    return DELETE;
                }
                case 4: {
                    return NO_OP;
                }
            }
            throw new IllegalArgumentException("no type mapped for [" + id + "]");
        }
    }

    public static final class Index
    implements TranslogOperation {
        public static final int FORMAT_6_0 = 8;
        public static final int FORMAT_NO_PARENT = 9;
        public static final int FORMAT_NO_VERSION_TYPE = 10;
        public static final int FORMAT_NO_DOC_TYPE = 11;
        public static final int SERIALIZATION_FORMAT = 11;
        private final String id;
        private final long autoGeneratedIdTimestamp;
        private final long seqNo;
        private final long primaryTerm;
        private final long version;
        private final BytesReference source;
        private final String routing;

        private Index(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format >= 8) : "format was: " + format;
            this.id = in.readString();
            if (format < 11) {
                in.readString();
            }
            this.source = in.readBytesReference();
            this.routing = in.readOptionalString();
            if (format < 9) {
                in.readOptionalString();
            }
            this.version = in.readLong();
            if (format < 10) {
                in.readByte();
            }
            this.autoGeneratedIdTimestamp = in.readLong();
            this.seqNo = in.readLong();
            this.primaryTerm = in.readLong();
        }

        public Index(EngineOperation.Index index, EngineResult.IndexResult indexResult) {
            this.id = index.id();
            this.source = index.source();
            this.routing = index.routing();
            this.seqNo = indexResult.getSeqNo();
            this.primaryTerm = index.primaryTerm();
            this.version = indexResult.getVersion();
            this.autoGeneratedIdTimestamp = index.getAutoGeneratedIdTimestamp();
        }

        public Index(String id, long seqNo, long primaryTerm, byte[] source) {
            this(id, seqNo, primaryTerm, -3L, source, null, -1L);
        }

        public Index(String id, long seqNo, long primaryTerm, long version, byte[] source, String routing, long autoGeneratedIdTimestamp) {
            this.id = id;
            this.source = new BytesArray(source);
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
            this.routing = routing;
            this.autoGeneratedIdTimestamp = autoGeneratedIdTimestamp;
        }

        @Override
        public Type opType() {
            return Type.INDEX;
        }

        @Override
        public long estimateSize() {
            return 2 * this.id.length() + this.source.length() + (this.routing != null ? 2 * this.routing.length() : 0) + 32;
        }

        public String id() {
            return this.id;
        }

        public String routing() {
            return this.routing;
        }

        public BytesReference source() {
            return this.source;
        }

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public long version() {
            return this.version;
        }

        @Override
        public Source getSource() {
            return new Source(this.source, this.routing);
        }

        private void write(StreamOutput out) throws IOException {
            int format = out.getVersion().onOrAfter(OpenSearchVersion.V_2_0_0) ? 11 : 10;
            out.writeVInt(format);
            out.writeString(this.id);
            if (format < 11) {
                out.writeString("_doc");
            }
            out.writeBytesReference(this.source);
            out.writeOptionalString(this.routing);
            if (format < 9) {
                out.writeOptionalString(null);
            }
            out.writeLong(this.version);
            if (format < 10) {
                out.writeByte(VersionType.EXTERNAL.getValue());
            }
            out.writeLong(this.autoGeneratedIdTimestamp);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Index index = (Index)o;
            if (this.version != index.version || this.seqNo != index.seqNo || this.primaryTerm != index.primaryTerm || !this.id.equals(index.id) || this.autoGeneratedIdTimestamp != index.autoGeneratedIdTimestamp || !this.source.equals(index.source)) {
                return false;
            }
            return !(this.routing != null ? !this.routing.equals(index.routing) : index.routing != null);
        }

        public int hashCode() {
            int result = this.id.hashCode();
            result = 31 * result + Long.hashCode(this.seqNo);
            result = 31 * result + Long.hashCode(this.primaryTerm);
            result = 31 * result + Long.hashCode(this.version);
            result = 31 * result + this.source.hashCode();
            result = 31 * result + (this.routing != null ? this.routing.hashCode() : 0);
            result = 31 * result + Long.hashCode(this.autoGeneratedIdTimestamp);
            return result;
        }

        public String toString() {
            return "Index{id='" + this.id + "', seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", version=" + this.version + ", autoGeneratedIdTimestamp=" + this.autoGeneratedIdTimestamp + "}";
        }

        public long getAutoGeneratedIdTimestamp() {
            return this.autoGeneratedIdTimestamp;
        }
    }

    public static final class Delete
    implements TranslogOperation {
        private static final int FORMAT_6_0 = 4;
        public static final int FORMAT_NO_PARENT = 5;
        public static final int FORMAT_NO_VERSION_TYPE = 6;
        public static final int FORMAT_NO_DOC_TYPE = 7;
        public static final int SERIALIZATION_FORMAT = 7;
        private final String id;
        private final long seqNo;
        private final long primaryTerm;
        private final long version;

        private Delete(StreamInput in) throws IOException {
            int format = in.readVInt();
            assert (format >= 4) : "format was: " + format;
            if (format < 7) {
                in.readString();
            }
            this.id = in.readString();
            if (format < 7) {
                String docType = in.readString();
                assert (docType.equals(ParseField.CommonMetaFields.ID_FIELD.getPreferredName())) : docType + " != " + ParseField.CommonMetaFields.ID_FIELD.getPreferredName();
                in.readBytesRef();
            }
            this.version = in.readLong();
            if (format < 6) {
                in.readByte();
            }
            this.seqNo = in.readLong();
            this.primaryTerm = in.readLong();
        }

        public Delete(EngineOperation.Delete delete, EngineResult.DeleteResult deleteResult) {
            this(delete.id(), deleteResult.getSeqNo(), delete.primaryTerm(), deleteResult.getVersion());
        }

        public Delete(String id, long seqNo, long primaryTerm) {
            this(id, seqNo, primaryTerm, -3L);
        }

        public Delete(String id, long seqNo, long primaryTerm, long version) {
            this.id = Objects.requireNonNull(id);
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.version = version;
        }

        @Override
        public Type opType() {
            return Type.DELETE;
        }

        @Override
        public long estimateSize() {
            return this.id.length() * 2 + 24;
        }

        public String id() {
            return this.id;
        }

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public long version() {
            return this.version;
        }

        @Override
        public Source getSource() {
            throw new IllegalStateException("trying to read doc source from delete operation");
        }

        private void write(StreamOutput out) throws IOException {
            int format = out.getVersion().onOrAfter(OpenSearchVersion.V_2_0_0) ? 7 : 6;
            out.writeVInt(format);
            if (format < 7) {
                out.writeString("_doc");
            }
            out.writeString(this.id);
            if (format < 7) {
                out.writeString(ParseField.CommonMetaFields.ID_FIELD.getPreferredName());
                out.writeBytesRef(Uid.encodeId(this.id));
            }
            out.writeLong(this.version);
            if (format < 6) {
                out.writeByte(VersionType.EXTERNAL.getValue());
            }
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Delete delete = (Delete)o;
            return this.version == delete.version && this.seqNo == delete.seqNo && this.primaryTerm == delete.primaryTerm;
        }

        public int hashCode() {
            int result = Long.hashCode(this.seqNo);
            result = 31 * result + Long.hashCode(this.primaryTerm);
            result = 31 * result + Long.hashCode(this.version);
            return result;
        }

        public String toString() {
            return "Delete{seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", version=" + this.version + "}";
        }
    }

    public static final class NoOp
    implements TranslogOperation {
        private final long seqNo;
        private final long primaryTerm;
        private final String reason;

        @Override
        public long seqNo() {
            return this.seqNo;
        }

        @Override
        public long primaryTerm() {
            return this.primaryTerm;
        }

        public String reason() {
            return this.reason;
        }

        private NoOp(StreamInput in) throws IOException {
            this.seqNo = in.readLong();
            this.primaryTerm = in.readLong();
            this.reason = in.readString();
        }

        public NoOp(long seqNo, long primaryTerm, String reason) {
            assert (seqNo > -1L);
            assert (primaryTerm >= 0L);
            assert (reason != null);
            this.seqNo = seqNo;
            this.primaryTerm = primaryTerm;
            this.reason = reason;
        }

        private void write(StreamOutput out) throws IOException {
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeString(this.reason);
        }

        @Override
        public Type opType() {
            return Type.NO_OP;
        }

        @Override
        public long estimateSize() {
            return 2 * this.reason.length() + 16;
        }

        @Override
        public Source getSource() {
            throw new UnsupportedOperationException("source does not exist for a no-op");
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            NoOp that = (NoOp)obj;
            return this.seqNo == that.seqNo && this.primaryTerm == that.primaryTerm && this.reason.equals(that.reason);
        }

        public int hashCode() {
            return 961 * Long.hashCode(this.seqNo) + 31 * Long.hashCode(this.primaryTerm) + this.reason().hashCode();
        }

        public String toString() {
            return "NoOp{seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", reason='" + this.reason + "'}";
        }
    }

    public static class Source {
        public final BytesReference source;
        public final String routing;

        public Source(BytesReference source, String routing) {
            this.source = source;
            this.routing = routing;
        }
    }
}

