/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.index.warmer;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.index.Index;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.index.fielddata.BaseIndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldData;
import io.skylite.core.index.fielddata.IndexFieldDataService;
import io.skylite.core.index.shard.IndexShardState;
import io.skylite.core.index.shard.ShardId;
import io.skylite.core.index.warmer.ShardIndexWarmerService;
import io.skylite.core.lucene.index.SkyliteDirectoryReader;
import io.skylite.core.mapper.BaseMappedFieldType;
import io.skylite.core.mapper.MappedFieldType;
import io.skylite.core.mapper.MapperService;
import io.skylite.core.threadpool.ThreadPool;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.LeafReaderContext;

public final class IndexWarmer {
    private static final Logger logger = LogManager.getLogger(IndexWarmer.class);
    private final List<Listener> listeners;

    public IndexWarmer(ThreadPool threadPool, IndexFieldDataService indexFieldDataService, Listener ... listeners) {
        ArrayList<FieldDataWarmer> list = new ArrayList<FieldDataWarmer>();
        ExecutorService executor = threadPool.executor("warmer");
        list.add(new FieldDataWarmer(executor, indexFieldDataService));
        Collections.addAll(list, listeners);
        this.listeners = Collections.unmodifiableList(list);
    }

    public void warm(SkyliteDirectoryReader reader, Index index, IndexShardState shardState, ShardId shardId, ShardIndexWarmerService warmerService, MapperService shardMapperService, IndexSettings settings) {
        if (shardState == IndexShardState.CLOSED) {
            return;
        }
        if (!settings.isWarmerEnabled()) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace("{} top warming [{}]", (Object)shardId, (Object)reader);
        }
        warmerService.onPreWarm();
        long time = System.nanoTime();
        ArrayList<TerminationHandle> terminationHandles = new ArrayList<TerminationHandle>();
        for (Listener listener : this.listeners) {
            terminationHandles.add(listener.warmReader(index, shardMapperService, warmerService, reader));
        }
        for (TerminationHandle terminationHandle : terminationHandles) {
            try {
                terminationHandle.awaitTermination();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("top warming has been interrupted", (Throwable)e);
                break;
            }
        }
        long took = System.nanoTime() - time;
        warmerService.onPostWarm(took);
        if (warmerService.logger().isTraceEnabled()) {
            warmerService.logger().trace("top warming took [{}]", (Object)new TimeValue(took, TimeUnit.NANOSECONDS));
        }
    }

    private static class FieldDataWarmer
    implements Listener {
        private final Executor executor;
        private final IndexFieldDataService indexFieldDataService;

        FieldDataWarmer(Executor executor, IndexFieldDataService indexFieldDataService) {
            this.executor = executor;
            this.indexFieldDataService = indexFieldDataService;
        }

        @Override
        public TerminationHandle warmReader(Index index, MapperService mapperService, ShardIndexWarmerService warmerService, SkyliteDirectoryReader reader) {
            HashMap<String, BaseMappedFieldType> warmUpGlobalOrdinals = new HashMap<String, BaseMappedFieldType>();
            for (BaseMappedFieldType fieldType : mapperService.getEagerGlobalOrdinalsFields()) {
                String indexName = fieldType.name();
                warmUpGlobalOrdinals.put(indexName, fieldType);
            }
            CountDownLatch latch = new CountDownLatch(warmUpGlobalOrdinals.size());
            for (BaseMappedFieldType fieldType : warmUpGlobalOrdinals.values()) {
                this.executor.execute(() -> {
                    block8: {
                        try {
                            long start = System.nanoTime();
                            BaseIndexFieldData.Global ifd = (BaseIndexFieldData.Global)this.indexFieldDataService.getForField((MappedFieldType)MappedFieldType.class.cast(fieldType), this.indexFieldDataService.index().getName(), () -> {
                                throw new UnsupportedOperationException("search lookup not available when warming an index");
                            });
                            if (ifd instanceof IndexFieldData.Global) {
                                IndexFieldData.Global globalFieldData = (IndexFieldData.Global)ifd;
                                BaseIndexFieldData global = globalFieldData.loadGlobal((DirectoryReader)reader);
                                if (!reader.leaves().isEmpty()) {
                                    global.load((LeafReaderContext)reader.leaves().get(0));
                                }
                                if (warmerService.logger().isTraceEnabled()) {
                                    warmerService.logger().trace("warmed global ordinals for [{}], took [{}]", (Object)fieldType.name(), (Object)TimeValue.timeValueNanos((long)(System.nanoTime() - start)));
                                }
                                break block8;
                            }
                            throw new IllegalArgumentException("Expected IndexFieldData for field [" + fieldType.name() + "] but found " + String.valueOf(ifd.getClass()));
                        }
                        catch (Exception e) {
                            warmerService.logger().warn(() -> new ParameterizedMessage("failed to warm-up global ordinals for [{}]", (Object)fieldType.name()), (Throwable)e);
                        }
                        finally {
                            latch.countDown();
                        }
                    }
                });
            }
            return () -> latch.await();
        }
    }

    public static interface Listener {
        public TerminationHandle warmReader(Index var1, MapperService var2, ShardIndexWarmerService var3, SkyliteDirectoryReader var4);
    }

    public static interface TerminationHandle {
        public static final TerminationHandle NO_WAIT = () -> {};

        public void awaitTermination() throws InterruptedException;
    }
}

