/*
 * Decompiled with CFR 0.152.
 */
package io.skylite.core.indices;

import io.skylite.common.unit.TimeValue;
import io.skylite.core.index.IndexSettings;
import io.skylite.core.indices.replication.common.ReplicationType;
import io.skylite.core.settings.Setting;
import io.skylite.core.settings.spi.SettingsProvider;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IndicesServiceSettings {
    public static final Setting<Boolean> INDICES_ID_FIELD_DATA_ENABLED_SETTING = Setting.boolSetting("indices.id_field_data.enabled", true, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<TimeValue> INDICES_CACHE_CLEAN_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.cache.cleanup_interval", TimeValue.timeValueMinutes((long)1L), Setting.Property.NodeScope);
    public static final String CLUSTER_SETTING_REPLICATION_TYPE = "cluster.indices.replication.strategy";
    public static final Setting<ReplicationType> CLUSTER_REPLICATION_TYPE_SETTING = new Setting<ReplicationType>("cluster.indices.replication.strategy", ReplicationType.DOCUMENT.toString(), ReplicationType::parseString, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<TimeValue> CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("cluster.default.index.refresh_interval", IndexSettings.DEFAULT_REFRESH_INTERVAL, IndexSettings.MINIMUM_REFRESH_INTERVAL, new ClusterDefaultRefreshIntervalValidator(), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<TimeValue> CLUSTER_MINIMUM_INDEX_REFRESH_INTERVAL_SETTING = Setting.timeSetting("cluster.minimum.index.refresh_interval", IndexSettings.MINIMUM_REFRESH_INTERVAL, IndexSettings.MINIMUM_REFRESH_INTERVAL, new ClusterMinimumRefreshIntervalValidator(), Setting.Property.NodeScope, Setting.Property.Dynamic);
    public static final Setting<Boolean> CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING = Setting.boolSetting("cluster.remote_store.index.restrict.async-durability", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<Boolean> CLUSTER_RESTRICT_INDEX_REPLICATION_TYPE_SETTING = Setting.boolSetting("cluster.index.restrict.replication_type", false, Setting.Property.NodeScope, Setting.Property.Final);
    public static final Setting<Boolean> WRITE_DANGLING_INDICES_INFO_SETTING = Setting.boolSetting("gateway.write_dangling_indices_info", true, Setting.Property.NodeScope);

    private static void validateRefreshIntervalSettings(TimeValue minimumRefreshInterval, TimeValue defaultRefreshInterval) {
        if (minimumRefreshInterval.compareTo(defaultRefreshInterval) > 0) {
            throw new IllegalArgumentException("cluster minimum index refresh interval [" + String.valueOf(minimumRefreshInterval) + "] more than cluster default index refresh interval [" + String.valueOf(defaultRefreshInterval) + "]");
        }
    }

    private static final class ClusterDefaultRefreshIntervalValidator
    implements Setting.Validator<TimeValue> {
        private ClusterDefaultRefreshIntervalValidator() {
        }

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue defaultRefreshInterval, Map<Setting<?>, Object> settings) {
            TimeValue minimumRefreshInterval = (TimeValue)settings.get(CLUSTER_MINIMUM_INDEX_REFRESH_INTERVAL_SETTING);
            IndicesServiceSettings.validateRefreshIntervalSettings(minimumRefreshInterval, defaultRefreshInterval);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<TimeValue>> settings = List.of(CLUSTER_MINIMUM_INDEX_REFRESH_INTERVAL_SETTING);
            return settings.iterator();
        }
    }

    private static final class ClusterMinimumRefreshIntervalValidator
    implements Setting.Validator<TimeValue> {
        private ClusterMinimumRefreshIntervalValidator() {
        }

        @Override
        public void validate(TimeValue value) {
        }

        @Override
        public void validate(TimeValue minimumRefreshInterval, Map<Setting<?>, Object> settings) {
            TimeValue defaultRefreshInterval = (TimeValue)settings.get(CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING);
            IndicesServiceSettings.validateRefreshIntervalSettings(minimumRefreshInterval, defaultRefreshInterval);
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<TimeValue>> settings = List.of(CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING);
            return settings.iterator();
        }
    }

    public static final class SettingsProviderImpl
    implements SettingsProvider {
        @Override
        public List<? extends Setting<?>> getSettings() {
            return Arrays.asList(INDICES_ID_FIELD_DATA_ENABLED_SETTING, INDICES_CACHE_CLEAN_INTERVAL_SETTING, CLUSTER_DEFAULT_INDEX_REFRESH_INTERVAL_SETTING, CLUSTER_MINIMUM_INDEX_REFRESH_INTERVAL_SETTING, CLUSTER_REPLICATION_TYPE_SETTING, CLUSTER_REMOTE_INDEX_RESTRICT_ASYNC_DURABILITY_SETTING, CLUSTER_RESTRICT_INDEX_REPLICATION_TYPE_SETTING, WRITE_DANGLING_INDICES_INFO_SETTING);
        }
    }
}

